#!/bin/sh
#$Id: checktunnel.sh,v 1.2 2001/04/30 12:19:00 acormier Exp $
#
#TAG : Display tunnel information
# <TSP_TUNNEL_INTERFACE> <TSP_CLIENT_ADDRESS_IPV4> <TSP_SERVER_ADDRESS_IPV4> <TSP_CLIENT_ADDRESS_IPV6> <TSP_SERVER_ADDRESS_IPV6> 
# <TSP_TUNNEL_PREFIXLEN> <TSP_HOME_INTERFACE>  <TSP_PREFIX> <TSP_PREFIXLEN>   
#
#
# Program localization 

cat <<EOT
Host type: [$TSP_HOST_TYPE]

Tunnel end-points:
Local interface: [$TSP_TUNNEL_INTERFACE]

Client:	v4[$TSP_CLIENT_ADDRESS_IPV4]
	v6[$TSP_CLIENT_ADDRESS_IPV6/$TSP_TUNNEL_PREFIXLEN]

Server:	v4[$TSP_SERVER_ADDRESS_IPV4]
	v6[$TSP_SERVER_ADDRESS_IPV6/$TSP_TUNNEL_PREFIXLEN]

EOT

if [ X"${TSP_HOST_TYPE}" = X"ROUTER" -o X"${TSP_HOST_TYPE}" = X"router" ]; then

cat <<EOT
Routing information:
Home network interface: [$TSP_HOME_INTERFACE]
  (for prefix advertisement)

Prefix: [$TSP_PREFIX/$TSP_PREFIXLEN]

EOT
fi

cat <<EOT
Thank you for using Freenet6.
EOT

return 0
