/*
---------------------------------------------------------------------------
 $Id: protocol.h,v 1.8 2001/05/30 16:13:53 acormier Exp $
---------------------------------------------------------------------------
Copyright (c) 2001 Viagenie Inc. All rights reserved.

     The contents of this file are subject to the Viagnie
     Public License Version 1.0 (the "License"); you may not
     use this file except in compliance with the License. You
     may obtain a copy of the License at
     http://www.freenet6.net/VPL/

     Software distributed under the License is distributed on
     an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either
     express or implied. See the License for the specific
     language governing rights and limitations under the
     License.

     The Original Code is _source code of the tunnel server
     protocol-client side_.

     The Initial Developer of the Original Code is Viagnie .

     All Rights Reserved.

     Contributor(s): ______________________________________.

---------------------------------------------------------------------------
*/

#ifndef PROTOCOL_H
#define PROTOCOL_H

#define SERVER_PORT "4343"
typedef struct stPayload {
  long	size, PayloadCapacity;
  char *payload;
} tPayload;

#define PROTOCOLMAXPAYLOADCHUNK	2048
#define PROTOCOLFRAMESIZE	4096
#define PROTOCOLMAXHEADER	70

enum { PROTOCOL_OK, PROTOCOL_ERROR, PROTOCOL_EMEM, PROTOCOL_ESYNTAX, PROTOCOL_ESIZE, PROTOCOL_EREAD };

/* Prototypes */

extern int tspConnect(char *server);
extern void tspClose(int socket);
extern void tspClearPayload(tPayload *Payload);
extern int tspGetStatusCode(char *payload);
extern char *tspGetStatusMsg(char *payload);
extern int tspReceive(int Socket, tPayload *Payload);
extern int tspSend(int Socket, tPayload *Payload);
extern char *tspAddPayloadString(tPayload *Payload, char *Addition);

#endif

/*----- protocol.h ----------------------------------------------------------*/













