/*
---------------------------------------------------------------------------
 $Id: network.c,v 1.10 2001/09/07 15:52:27 acormier Exp $
---------------------------------------------------------------------------
Copyright (c) 2001 Viagenie Inc. All rights reserved.

     The contents of this file are subject to the Viagnie
     Public License Version 1.0 (the "License"); you may not
     use this file except in compliance with the License. You
     may obtain a copy of the License at
     http://www.freenet6.net/VPL/

     Software distributed under the License is distributed on
     an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either
     express or implied. See the License for the specific
     language governing rights and limitations under the
     License.

     The Original Code is _source code of the tunnel server
     protocol-client side_.

     The Initial Developer of the Original Code is Viagnie .

     All Rights Reserved.

     Contributor(s): ______________________________________.

---------------------------------------------------------------------------
*/

#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdarg.h>
#ifdef sun
#include <strings.h>
#else
#include <string.h>
#endif
#include <unistd.h>

#include "network.h"

int NetConnect(char *Host, int Port)
{
  int                 sockfd;
  struct sockaddr_in  serv_addr;
  struct in_addr      *addr;

  if((addr = NetText2Addr(Host)) == NULL) {
    perror("Cannot find host");
    return -1;
  }

  bzero((char *) &serv_addr, sizeof(serv_addr));
  serv_addr.sin_family      = AF_INET;
  serv_addr.sin_port        = htons(Port);
  serv_addr.sin_addr.s_addr = addr->s_addr;

  /*
   * Open a TCP socket (an Internet stream socket).
   */

  if ( (sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
    perror("client: can't open stream socket");
    return -1;
  }

  /*
   * Connect to the server.
   */

  if (connect(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
    perror("client: can't connect to server");
    return -1;
  }

  return sockfd;
}

void NetClose(int Socket)
{
  shutdown(Socket, SHUT_RDWR);
  close(Socket);
}

int NetListen(int Port)
{
  int                sockfd;
  struct sockaddr_in serv_addr;

  /*
   * Open a TCP socket (an Internet stream socket).
   */

  if ( (sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
    perror("server: can't open stream socket");
    return -1;
  }

  /*
   * Bind our local address so that the client can send to us.
   */

  bzero((char *) &serv_addr, sizeof(serv_addr));
  serv_addr.sin_family      = AF_INET;
  serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  serv_addr.sin_port        = htons(Port);

  if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
    perror("server: can't bind local address");
    return -1;
  }

  if (listen(sockfd, 5) < 0) {
    perror("server: can't listen on socket");
    return -1;
  }

  return sockfd;
}

int NetAccept(int Socket, struct sockaddr_in *client)
{
  int clilen, NewSocket;
  struct sockaddr_in cli_addr;

  clilen = sizeof(cli_addr);
  NewSocket = accept(Socket, (struct sockaddr *) &cli_addr, &clilen);

  if (NewSocket < 0) {
    perror("server: accept error");
    return -1;
  }
  return NewSocket;
}

int NetPrintf(int Socket, char *Format, ...)
{
  va_list argp;
  int Length;
  char Data[1024];

  va_start(argp, Format);
  vsnprintf(Data, sizeof Data, Format, argp);
  va_end(argp);

  Length = strlen(Data);
  if(NetWrite(Socket, Data, strlen(Data)) != Length) {
    return 0;
  }

  return 1;
}

int NetWrite(int Socket, unsigned char *Data, size_t Length)
{
  size_t nleft, nwritten;
  unsigned char	*ptr;

  ptr = Data;	/* can't do pointer arithmetic on void* */
  nleft = Length;
  while (nleft > 0) {
    if ((nwritten = write(Socket, ptr, nleft)) <= 0) {
      return nwritten;		/* error */
    }

    nleft -= nwritten;
    ptr   += nwritten;
  }
  return(Length);
}

int NetRead(int Socket, unsigned char *Data, size_t Length)
{
  return(read(Socket, Data, Length));
}

int NetReadLine(int Socket, unsigned char *Data, size_t Length)
{
  char *ptr, done;
  int  nleft, nread, total;

  ptr   = Data;
  nleft = Length;
  total = 0;
  done  = 0;

  while(!done) {

    if((nread = NetRead(Socket, ptr, 1)) <= 0) {
      return -1;
    }

    nleft -= nread;
    ptr   += nread;
    total += nread;

    if(Data[total-1] == '\n') {
      done = 1;
    } else {
      if (nleft <= 0) return -1;
    }
  }

  Data[total] = 0;
  return total;
}

struct in_addr *NetText2Addr(char *Address)
{
  struct hostent *host;
  static struct in_addr saddr;

  /* First try it as aaa.bbb.ccc.ddd. */

  saddr.s_addr = inet_addr(Address);
  if (saddr.s_addr != -1) {
    return &saddr;
  }

  host = gethostbyname(Address);

  if (host != NULL) {
    return (struct in_addr *) *host->h_addr_list;
  }

  return NULL;
}

/* fork2 from http://www.landfield.com/faqs/unix-faq/programmer/faq/ */
int NetFork()
{
  pid_t pid;
  int status;
	
  if (!(pid = fork())) {
    switch (fork()) {
      case 0:  return 0;
      case -1: _exit(errno);    /* assumes all errnos are <256 */
      default: _exit(0);
    }
  }
	
  if (pid < 0 || waitpid(pid,&status,0) < 0) {
    return -1;
  }

  if (WIFEXITED(status)) {
    if (WEXITSTATUS(status) == 0) {
      return 1;
    } else {
      errno = WEXITSTATUS(status);
    }
  } else {
    errno = EINTR;  /* well, sort of :-) */
  }
	
  return -1;
}


