/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_ERRORIMPL_H
#define _SVN_ERRORIMPL_H

// svn
#include <svn_types.h>

// sc
#include "util/Error.h"

namespace svn
{

/**
 * svn_error_t* wrapping implementation of sc::Error.
 */
class ErrorImpl : public sc::Error
{
public:
  ErrorImpl( svn_error_t* error );
  virtual ~ErrorImpl();

  // Error
  // @{
  long       getCode() const;
  sc::String getMessage() const;
  sc::String getMessages() const;
  const sc::Error* getNested() const;
  // @}

  svn_error_t* getError() const;

private:
  sc::String getMessage(svn_error_t*) const;

  svn_error_t* _error;
};


} // namespace

#endif //  _SVN_ERRORIMPL_H
