separate (ErrorHandler.Conversions.ToString.UncondDependency)
procedure UncondDependencyExpl (E_Str   : in out E_Strings.T)

is
begin
   case Err_Type is
      when ErrorHandler.Not_Used_New =>
         E_Strings.Append_String
            (E_Str => E_Str,
             Str   => "The item before ""is not derived ..."" is an export or function return value and the item(s)" &
              " after are imports of the subprogram.  The message indicates that a dependency, stated in the dependency" &
              " relation (derives annotation) or implied by the function signature is not present in the code." &
              " The absence of a stated dependency" &
              " is always an error in either code or annotation.");
      when ErrorHandler.Not_Used =>
         E_Strings.Append_String
            (E_Str => E_Str,
             Str   => "The variable XXX, which appears in the dependency relation of a" &
              " procedure subprogram, as an import from which the export YYY is derived," &
              " is not used in the code for that purpose. YYY may be a function return value." &
              " This version of the message has been retained for backward compatibility.");
      when ErrorHandler.Ineff_Init =>
         E_Strings.Append_String
            (E_Str => E_Str,
             Str   => "Here XXX is an own variable of a package, initialized in the package" &
              " initialization." &
              " The message states that XXX is updated elsewhere, before being read.");
      when ErrorHandler.Ineff_Local_Init =>
         E_Strings.Append_String
            (E_Str => E_Str,
             Str   => "Issued if the value assigned to a variable at declaration cannot" &
              " affect the final value of any exported variable of the subprogram in" &
              " which it occurs because, for example, it is overwritten before it is used.");
      when ErrorHandler.Policy_Violation =>
         E_Strings.Append_String
            (E_Str => E_Str,
             Str   => "Issued if safety or security policy checking is enabled and the specified" &
              " dependency relation contains a relationship in which the flow of information" &
              " from state or input to state or output violates the selected policy.");
      when others => null;
   end case;
end UncondDependencyExpl;
