/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;

public abstract class ExtensionHDU
extends BasicHDU {
    public ExtensionHDU(Header header) {
        super(header);
    }

    public String getExtensionType() throws FitsException {
        String xStr = this.myHeader.getStringValue("XTENSION");
        if (xStr == null) {
            throw new FitsException("Missing EXTENDed FITS file type");
        }
        if ((xStr = xStr.trim()).length() < 1) {
            throw new FitsException("Empty EXTENDed FITS file type");
        }
        return xStr;
    }

    public String getExtensionName() {
        return this.getTrimmedString("EXTNAME");
    }

    public int getExtensionVersion() {
        return this.myHeader.getIntValue("EXTVER", 1);
    }

    public int getExtensionLevel() {
        return this.myHeader.getIntValue("EXTLEVEL", 1);
    }
}

