/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;

public class ImarisTiffReader
extends BaseTiffReader {
    public ImarisTiffReader() {
        super("Imaris 5 (TIFF)", "ims");
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 3) {
            return false;
        }
        if (block.length < 8) {
            return true;
        }
        boolean little = block[0] == 73 && block[1] == 73;
        int ifdlocation = DataTools.bytesToInt(block, 4, little);
        if (ifdlocation < 0) {
            return false;
        }
        if (ifdlocation + 1 > block.length) {
            return true;
        }
        int ifdnumber = DataTools.bytesToInt(block, ifdlocation, 2, little);
        for (int i = 0; i < ifdnumber; ++i) {
            if (ifdlocation + 3 + i * 12 > block.length) {
                return false;
            }
            int ifdtag = DataTools.bytesToInt(block, ifdlocation + 2 + i * 12, 2, little);
            if (ifdtag != 322) continue;
            return true;
        }
        return false;
    }

    public boolean isThisType(String name, boolean open) {
        if (!super.isThisType(name, open)) {
            return false;
        }
        return open ? this.checkBytes(name, 1024) : true;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("ImarisTiffReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        if (this.in.readShort() == 18761) {
            this.in.order(true);
        }
        this.ifds = TiffTools.getIFDs(this.in);
        if (this.ifds == null) {
            throw new FormatException("No IFDs found");
        }
        this.status("Verifying IFD sanity");
        Vector<Hashtable> tmp = new Vector<Hashtable>();
        for (int i = 1; i < this.ifds.length; ++i) {
            long[] byteCounts = TiffTools.getIFDLongArray(this.ifds[i], 325, false);
            long[] offsets = TiffTools.getIFDLongArray(this.ifds[i], 324, false);
            for (int j = 0; j < byteCounts.length; ++j) {
                Hashtable t = (Hashtable)this.ifds[i].clone();
                TiffTools.putIFDValue(t, 325, byteCounts[j]);
                TiffTools.putIFDValue(t, 324, offsets[j]);
                tmp.add(t);
            }
        }
        this.status("Populating metadata");
        this.core.sizeC[0] = this.ifds.length - 1;
        this.core.sizeZ[0] = tmp.size() / this.core.sizeC[0];
        this.core.sizeT[0] = 1;
        this.core.sizeX[0] = TiffTools.getIFDIntValue(this.ifds[1], 256, false, 0);
        this.core.sizeY[0] = TiffTools.getIFDIntValue(this.ifds[1], 257, false, 0);
        this.ifds = tmp.toArray(new Hashtable[0]);
        this.core.imageCount[0] = this.core.sizeC[0] * this.core.sizeZ[0];
        this.core.currentOrder[0] = "XYZCT";
        this.core.interleaved[0] = false;
        this.core.rgb[0] = this.core.imageCount[0] != this.core.sizeZ[0] * this.core.sizeC[0] * this.core.sizeT[0];
        int bitsPerSample = TiffTools.getIFDIntValue(this.ifds[0], 258);
        int bitFormat = TiffTools.getIFDIntValue(this.ifds[0], 339);
        while (bitsPerSample % 8 != 0) {
            ++bitsPerSample;
        }
        if (bitsPerSample == 24 || bitsPerSample == 48) {
            bitsPerSample /= 3;
        }
        if (bitFormat == 3) {
            this.core.pixelType[0] = 6;
        } else if (bitFormat == 2) {
            switch (bitsPerSample) {
                case 8: {
                    this.core.pixelType[0] = 0;
                    break;
                }
                case 16: {
                    this.core.pixelType[0] = 2;
                    break;
                }
                case 32: {
                    this.core.pixelType[0] = 4;
                }
            }
        } else {
            switch (bitsPerSample) {
                case 8: {
                    this.core.pixelType[0] = 1;
                    break;
                }
                case 16: {
                    this.core.pixelType[0] = 3;
                    break;
                }
                case 32: {
                    this.core.pixelType[0] = 5;
                }
            }
        }
        this.status("Parsing comment");
        String comment = (String)this.getMeta("Comment");
        if (comment != null && comment.startsWith("[")) {
            StringTokenizer st = new StringTokenizer(comment, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                int equals = line.indexOf("=");
                if (equals < 0) continue;
                String key = line.substring(0, equals);
                String value = line.substring(equals + 1);
                this.addMeta(key.trim(), value.trim());
            }
            this.metadata.remove("Comment");
        }
        MetadataStore store = this.getMetadataStore();
        FormatTools.populatePixels(store, this);
    }
}

