/*

  Author:  Bob Dean
  Copyright (c) 1999, 2000


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <limits.h>
#include <fcntl.h>
#include <signal.h>
#include <stdarg.h>
#include <sys/shm.h>
#include <glib.h>
#include <math.h>
#include <dbsoundcard.h>
#include <dbchannel.h>
#include <dbdebug.h>
#include <dbaudiolib.h>

#include "prototypes.h"

	/* variables to access DBMix channels shared memory */
	extern  int shmid, sysshmid;
	extern dbfsd_data * sysdata;
	extern local_channel * local_channels;
	/* static local_channel * cue_channels; */
	extern local_channel * ch;

	extern int errno;
	extern int debug_level; /* declared in debug module */

	void DBAudio_perror(char *str)
	{
		char* str2 = NULL;

		switch(errno)
		{
			case SUCCESS:
				return;
			case ERROR_NOT_IMPLEMENTED:
				str2 = "DBAudio ERROR: The requested function has not yet been implemented.";
				break;
			case ERROR_BAD_CHANNEL:
				str2 = "DBAudio ERROR: Unknown channel type.";
				break;
			case ERROR_BAD_PARAM:
				str2 = "DBAudio ERROR: The function recieved a bad parameter.";
				break;
			case ERROR_NO_FREE_CHANNELS:
				str2 = "DBAudio ERROR: All channels into dbfsd are in use.";
				break;
			case ERROR_TOO_MUCH_DATA:
				str2 = "DBAudio ERROR: DBAudio_Write recieved a data block which is too large too process.";
				break;
			case ERROR_BAD_SAMPLERATE: 
				str2 = "DBAudio ERROR: The requested samplerate is out of range.";
				break;
			case ERROR_BAD_CHANNELTYPE:
				str2 = "DBAudio ERROR: Unknown channel type.";
				break;
			case ERROR_BAD_NUMCH:
				str2 = "DBAudio ERROR: Bad number of audio channels (it is neither stereo nor mono).";
				break;
			case ERROR_BAD_FORMAT:
				str2 = "DBAudio ERROR: The audio data format is unsupported.";
				break;
			case ERROR_CHANNEL_IN_USE:
				str2 = "DBAudio ERROR: The requested channel index is in use.";
				break;
			case ERROR_BAD_CHANNEL_ID:
				str2 = "DBAudio ERROR: The requested channel index is out of range.";
				break;
			case ERROR_TOO_LITTLE_DATA:
				str2 = "DBAudio ERROR: DBAudio_Write recieved a data block which is too small too process.";
				break;
			case ERROR_NOT_INITIALIZED:
				str2 = "DBAudio ERROR: DBAudioLib is not initialized.";
				break;
			case ERROR_INIT_FAILURE:
				str2 = "DBAudio ERROR: DBAudiolib initialization failed.";
				break;
			default: 
				perror(str);
				return;
		}
		
		if(str2 == NULL) 
		{
			fprintf(stderr,"DBAUDIO_PERROR FAILURE: error code %d\n",errno);
		}

		fprintf(stderr,str);
		fprintf(stderr,str2);
		fprintf(stderr,"\n");
	}

#ifdef __cplusplus
}
#endif
