/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common/Exception.h"
#include "common/NCO.h"

#include "JT44Lookups.h"
#include "JT44Send.h"
#include "JT44Defs.h"
#include "JT44App.h"

#include <wx/datetime.h>
#include <wx/debug.h>
#include <wx/log.h>

CJT44Send::CJT44Send(const wxString& name, ISoundDev* soundDev, CPTTPort* pttPort) :
CSend(name, soundDev, pttPort)
{
	wxASSERT(soundDev != NULL);
	wxASSERT(pttPort != NULL);
}

CJT44Send::~CJT44Send()
{
}

void CJT44Send::run()
{
	wxString message = getMessage();
	message.resize(JT44_MESSAGE_LENGTH, wxT(' '));

	CJT44Lookups lookups;
	CNCO nco(JT44_SAMPLE_RATE, JT44_SEND_VOLUME);

	getPTTPort()->open();
	getPTTPort()->keyTX();

	getSoundDevice()->openWrite();

	waitForAudioStart();

	for (int i = 0; i < 135 && !isStopped(); i++) {
		int pos = lookups.lookupPosition(i);

		int tone;
		if (pos == -1) {
			tone = 118;
		} else {
			tone = lookups.lookupChar(message.GetChar(pos));

			if (tone == -1)
				tone = lookups.lookupChar(wxT(' '));
		}

		double freq, out[JT44_SYMBOL_LENGTH];

		freq = double(tone * 2) * double(JT44_SAMPLE_RATE) / double(JT44_SYMBOL_LENGTH);
		nco.generate(freq, out, JT44_SYMBOL_LENGTH);
		getSoundDevice()->write(out, JT44_SYMBOL_LENGTH);
	}

	getSoundDevice()->close();

	getPTTPort()->unkeyTX();
	getPTTPort()->close();
}

void CJT44Send::waitForAudioStart() const
{
	wxDateTime now = wxDateTime::UNow();

	switch (now.GetSecond()) {
		case 1:
		case 31:
			return;
		case 0:
		case 30:
			Sleep(1000 - now.GetMillisecond());
			break;
		default:
			throw CException(wxT("Weirdness in JT44 send timer"));
	}
}

void CJT44Send::error(const wxString& text)
{
        ::wxLogError(wxT("%s: %s"), getName().c_str(), text.c_str());

	::wxGetApp().error(text);
}
