/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.glib;

/**
 * Value is a polymorphic type that can hold values of any other
 * type.  This is used internally and should not be exposed outside
 * of the library.
 */ 
public class Value extends Boxed {
	
	
	/**
	 * Construct a new Value from a given org.gnu.glib.Type.
	 */
	public Value(Type type) {
		handle = Value.g_value_init(type.getHandle());
	}
	
	/**
	 * Construct a new Value object using a handle to a native object.
	 * @param aHandle The handle
	 */
	public Value(int aHandle) {
		handle = aHandle;
	}
	
	/**
	 * Create a copy of this Value object.
	 * 
	 * @return An object of type Value that contains the same
	 * data as the current object.
	 */
	public Value copy() {
		int [] dest = new int[1];
		Value.g_value_copy(handle, dest);
		return new Value(new Type(dest[0]));
	}

	/**
	 * Used internally by Java-Gnome to set a string value 
	 */
	public void setString( String value){
		if (value == null)
			value = "";
		g_value_set_string(handle, value);
	}

	/**
	 * Used internally by Java-Gnome
	 */
	public String getString(){
		return g_value_get_string(handle);
	}

	/**
	 * Used internally by Java-Gnome to set a boolean value 
	 */
	public void setBoolean(boolean value){
		g_value_set_boolean(handle, value );
	}

	/**
	 * Used internally by Java-Gnome
	 */
	public boolean getBoolean(){
		return g_value_get_boolean(handle);
	}
	
	/**
	 * Used internally by Java-Gnome to set an integer value 
	 */
	public void setInteger(int value){
		g_value_set_int(handle, value );
	}

	/**
	 * Used internally by Java-Gnome
	 */
	public int getInt(){
		return g_value_get_int(handle);
	}
	
	/**
	 * Used internally by Java-Gnome to set a long value 
	 */
	public void setLong(long value){
		g_value_set_long(handle, value );
	}

	/**
	 * Used internally by Java-Gnome
	 */
	public long getLong(){
		return g_value_get_long(handle);
	}
	
	/**
	 * Used internally by Java-Gnome to set a float value 
	 */
	public void setFloat(float value){
		g_value_set_float(handle, value );
	}
	
	/**
	 * Used internally by Java-Gnome
	 */
	public double getFloat(){
		return g_value_get_float(handle);
	}

	/**
	 * Used internally by Java-Gnome to set a double value 
	 */
	public void setDouble(double value){
		g_value_set_double(handle, value );
	}

	/**
	 * Used internally by Java-Gnome
	 */
	public double getDouble(){
		return g_value_get_double(handle);
	}


	/**
	 * Used internally by Java-Gnome
	 */
	public void setPixbuf(org.gnu.gdk.Pixbuf obj){
		g_value_set_pixbuf(handle, obj.getHandle());
	}

	/**
	 * Used internally
	 */
	public org.gnu.gdk.Pixbuf getPixbuf(){
		return new org.gnu.gdk.Pixbuf( g_value_get_pixbuf(handle));
	}
	native static final protected void g_value_set_pixbuf(int value, int obj);
	native static final protected int g_value_get_pixbuf(int value);
	/**
	 * Used internally by Java-Gnome
	 */
	public void setJavaObject(Object obj){
		g_value_set_java_object(handle, obj);
	}

	/**
	 * Used internally
	 */
	public Object getJavaObject(){
		return g_value_get_java_object(handle);
	}
	native static final protected void g_value_set_java_object(int value, Object obj);
	native static final protected Object g_value_get_java_object(int value);
	

	
	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
    native static final protected int g_value_init (int type);
    native static final protected void g_value_copy (int srcValue, int [] destValue);
	native static final protected int g_value_reset(int value);
	native static final protected void g_value_unset(int value);
	native static final protected void g_value_set_char(int value, byte vChar);
	native static final protected byte g_value_get_char(int value);
	native static final protected void g_value_set_boolean(int value, boolean vBoolean);
	native static final protected boolean g_value_get_boolean(int value);
	native static final protected void g_value_set_int(int value, int vInt);
	native static final protected int g_value_get_int(int value);
	native static final protected void g_value_set_long(int value, long vLong);
	native static final protected long g_value_get_long(int value);
	native static final protected void g_value_set_float(int value, double vFloat);
	native static final protected double g_value_get_float(int value);
	native static final protected void g_value_set_double(int value, double vDouble);
	native static final protected double g_value_get_double(int value);
	native static final protected void g_value_set_string(int value, String vString);
	native static final protected String g_value_get_string(int value);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
