#!/usr/bin/perl
#
#    $Horde: imp/scripts/imp2horde.pl,v 1.2.2.6 2003/01/10 17:32:34 jan Exp $
#
#    File:      imp2horde.pl
#    Author:    Christophe Guilloux - rootix@bootix.net
#    Version:   1.1
#
#    Date:      4/12/01
#    History:   code taken from imp2turba.pl and adapted to imp2horde.pl
#    Purpose:   This script converts an old imp preferences database contents
#               to the newer horde table format, it was written for
#               mysql, but could be easily ported to other databases
#
#    Usage:     Modify the variables at the beginning of the script
#               so that your database user/password, location and imp
#               database and horde database are correct.
#
#    Date:      27/5/02
#               make the database type configurable.
#
#    Date:      19/6/02
#               a few of the most important variables can now be also passed as arguments to
#               enable usage in scripts Tomas Pospisek - tpo_deb@sourcepole.ch


use DBI;
use Getopt::Long;

my $dbtype         = 'mysql';
# my $dbtype         = 'Pg';

my $location       = 'localhost';
my $port_num       = '3306';
my $username       = 'horde';
my $password       = '*****';

my $IMP_DATABASE   = 'horde';
my $IMP_TABLE      = 'imp_pref';
my $HORDE_DATABASE = 'horde';
my $HORDE_TABLE    = 'horde_prefs';
my $domain         = 'example.com';
my $identity_name  = 'Default Identity';

my $help = '';

GetOptions('help'               => \$help,
           'dbtype=s'           => \$dbtype,
           'username=s'         => \$username,
           'password=s'         => \$password,
           'port_num=i'         => \$port_num,
           'host=s'             => \$location,
           'domain=s'           => \$domain,
           'imp-database=s'     => \$IMP_DATABASE,
           'imp-table=s'        => \$IMP_TABLE,
           'horde-database=s'   => \$HORDE_DATABASE,
           'horde-table=s'      => \$HORDE_TABLE,
           'default-identity=s' => \$identity_name);

if ($help) {
   print <<EOF;
imp2horde.pl: converts old imp preferences to the
              newer horde database

optional parameters     Current settings:

    --dbtype            $dbtype
    --username          $username
    --password          $password
    --port_num          $port_num
    --host              $location
    --domain            $domain
    --imp-database      $IMP_DATABASE
    --imp-table         $IMP_TABLE
    --horde-database    $HORDE_DATABASE
    --horde-table       $HORDE_TABLE
    --default-identity  $identity_name
EOF
    exit;
}

my $dbi_options = {RaiseError => 1, ChopBlanks => 1, AutoCommit => 1};

$db_imphandle = DBI->connect("DBI:$dbtype:$IMP_DATABASE:$location:$port_num",
                             $username, $password, $dbi_options)
                || die ("Connection error: $DBI::errstr");

$db_horde = DBI->connect("DBI:$dbtype:$HORDE_DATABASE:$location:$port_num",
                         $username, $password, $dbi_options)
            || die ("Connection error: $DBI::errstr");

$imp_statement = $db_imphandle->prepare("SELECT username, fullname, replyto, lang, sig FROM $IMP_TABLE");
$imp_statement->execute();

$horde_statement = "DELETE FROM $HORDE_TABLE";
$horde_statement = $db_horde->prepare($horde_statement)
                   || die "prepare: $$stmt: $DBI::errstr";
$horde_statement->execute || die "execute: $$stmt: $DBI::errstr";

while (my ($owner, $fullname, $replyto, $lang, $sig) = $imp_statement->fetchrow_array()) {

    # Remove the @domain.com part from the $owner, doesn't work in Horde
    $owner =~ s/\@.*$//;
    $owner .= "\@$domain";

    # Quote the strings appropriately for the database
    my $quoted_owner    = $db_imphandle->quote($owner);
    my $quoted_fullname = $db_imphandle->quote($fullname);
    my $value           = "a:1:{i:0;a:9:{s:2:\"id\";s:".length($identity_name).":\"".$identity_name."\";s:8:\"fullname\";s:".length($fullname).":\"$fullname\";s:9:\"from_addr\";s:0:\"\";s:12:\"replyto_addr\";s:".length($replyto).":\"$replyto\";s:9:\"signature\";s:".length($sig).":\"$sig\";s:9:\"sig_first\";i:0;s:10:\"sig_dashes\";s:1:\"1\";s:16:\"sent_mail_folder\";s:15:\"INBOX.sent-mail\";s:14:\"save_sent_mail\";s:1:\"1\";}}";
    my $quoted_value    = $db_horde->quote($value);

    $horde_statement = "INSERT INTO $HORDE_TABLE VALUES ($quoted_owner, 'horde', 'identities', $quoted_value)";
    $horde_statement = $db_horde->prepare($horde_statement)
                       || die "prepare: $$stmt: $DBI::errstr";
    $horde_statement->execute || die "execute: $$stmt: $DBI::errstr";
    $horde_statement->finish();

}

$imp_statement->finish();
$horde_statement->finish();
$db_imphandle->disconnect;
$db_horde->disconnect;
