/*  GNUWash	-	Backend
    Copyright (C) 2004 Mathias Menzel-Nielsen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/


#include <AppKit/AppKit.h>
#include "Backend.h"


@implementation Backend

{
}

- (id) init
{
	self = [super init];
	return self;
}

- (void) applicationDidFinishLaunching: (NSNotification *) not
{
	id userdef;
	int i;
	//do init stuff
	NSMutableDictionary *defaults = [NSMutableDictionary dictionary];
	NSMutableDictionary *d1 = [NSMutableDictionary dictionary];
	NSMutableArray *a1 = [[NSMutableArray alloc] init];
	
	[d1 setObject: @"Wash" forKey: @"Button"];
	[d1 setObject: @"3600" forKey: @"Time"];
	[d1 setObject: @"gnuwash.tiff" forKey: @"Image"];
	[a1 addObject: d1 ];
	RELEASE(d1);
	d1 = [NSMutableDictionary dictionary];
	[d1 setObject: @"Pizza" forKey: @"Button"];
	[d1 setObject: @"600" forKey: @"Time"];
	[d1 setObject: @"pizza.tiff" forKey: @"Image"];
	[a1 addObject: d1 ];
	RELEASE(d1);
	d1 = [NSMutableDictionary dictionary];
	[d1 setObject: @"Tea" forKey: @"Button"];
	[d1 setObject: @"180" forKey: @"Time"];
	[d1 setObject: @"tea.tiff" forKey: @"Image"];
	[a1 addObject: d1 ];
	
	userdef = [NSUserDefaults standardUserDefaults];
	[defaults setObject: a1 forKey: @"Presets"];
	[userdef registerDefaults: defaults];
	[userdef synchronize];

	RELEASE(d1);
	//RELEASE(defaults);
	//load todo objects
	
	todos = [[NSMutableArray alloc] init];
	NSMutableArray *presets = [userdef objectForKey:@"Presets"]; 
	NSImage *img;
	for(i=0; i< [presets count] ; i++)
	{
		if([[[presets objectAtIndex: i] objectForKey: @"Image"]
hasPrefix: @"/"])
		  img = [[NSImage alloc] initByReferencingFile: [[presets objectAtIndex: i] objectForKey: @"Image"]];
		else
		  img =  [NSImage imageNamed: [[presets objectAtIndex:
i] objectForKey: @"Image"]];
		[img setName:  [[presets objectAtIndex: i] objectForKey: @"Image"]];
		[todos addObject: 
			[[Todo alloc] initWithDescription: [[presets objectAtIndex: i] objectForKey: @"Button"] 
			andImage: img
			andTime: [[[presets objectAtIndex: i] objectForKey:
@"Time"] intValue]
		
			]
		];
	}
	aktTodo = 0;	
	timer = nil;

	[imageView setImage: [[todos objectAtIndex: aktTodo] getImage]];
	
	[NSApp setApplicationIconImage: [NSImage imageNamed: @"GNUTimer.tiff"]];
	[button setStringValue: [[todos objectAtIndex: aktTodo]
getDescription]];
	
	NSLog(@"initialized");
	
}

+ (NSString *) secondsToDuration: (long) seconds
{
	int days = seconds/(3600*24);
	int hours = (seconds-(days*3600*24))/3600;
	int minutes = (seconds-(days*3600*24)-(hours*3600))/60;
	int secs = seconds % 60;
	return [NSString localizedStringWithFormat: @"%d d : %d h : %d m : %d s",days,hours,minutes,secs];
}

- (void) tick
{
	id todo;
	todo = [todos objectAtIndex: aktTodo];
	[todo elapseTime: 1];
	[progress setDoubleValue: [todo getTime]];
	[text setStringValue: [Backend secondsToDuration: [todo getTime]]];
	if([[todos objectAtIndex: aktTodo] finished])
	{
		//finished
		[timer invalidate];
		timer=nil;
		[imageView setImage: [NSImage imageNamed:@"alarm.tiff"]];
		[text setStringValue: @"Hurray!"];
		[button setStringValue: @"Restart"];


	}
}
- (void) showPreferences: (id)sender
{
	[NSBundle loadNibNamed: @"Preferences.gorm" owner: self];
	[NSApp runModalForWindow: preferences];
}


- (void) StartWashing: (id)sender
{
	id todo;
	todo = [todos objectAtIndex: aktTodo];
	
	if(timer != nil){
	 if([timer isValid]){
		[timer invalidate];
		[todo resetTime];
		[button setStringValue: @"Restart"];
		timer = nil;
	 }
	}
	else{
		
	[todo resetTime];
	[progress setMaxValue: [todo getMaxTime]];
	[progress setMinValue: 0];
	[progress setDoubleValue: [todo getTime]];
	
	timer = [NSTimer scheduledTimerWithTimeInterval: 1.0 target: self selector: @selector(tick) userInfo: nil repeats: YES];
	[button setStringValue: @"STOP"];
	[text setStringValue: [Backend secondsToDuration: [todo getTime]]];
	[imageView setImage: [[todos objectAtIndex: aktTodo] getImage]];
	}
}

- (void) clickedButton: (id)sender
{
	aktTodo++;
	if (aktTodo > ([todos count] -1))
		aktTodo=0;
	
	[imageView setImage: [[todos objectAtIndex: aktTodo] getImage]];
	[button setStringValue: [[todos objectAtIndex: aktTodo]
getDescription]];
}

- (void) savePreferences
{

	int i;
	id todo;
	NSMutableArray *array = [[NSMutableArray alloc] init];
	printf("bla\n");
	for( i=0; i< [todos count]; i++)
		{
		
		todo = [todos objectAtIndex: i];
		printf( "%d\n",(int) [todo getTime]);
		printf("todo\n");
		NSLog(  [todo getDescription]);
	//make a dictionary for the preferences
		NSDictionary *preset = [NSDictionary 
			dictionaryWithObjectsAndKeys: 
			[todo getDescription], @"Button",
			[NSString stringWithFormat: @"%d",(int) [todo
getMaxTime]], @"Time",
			[[todo getImage] name], @"Image", nil]; 
		printf("dict\n");
		NSLog( [[todo getImage] name] );
		[array addObject: preset];
		printf("it:%d\n",i);
	}
	[[NSUserDefaults standardUserDefaults] setObject: array forKey:@"Presets"];
	printf("set\n");
	
	//[[NSUserDefaults standardUserDefaults] registerDefaults:settings];
	[[NSUserDefaults standardUserDefaults]  synchronize];
	printf("!\n");
	//RELEASE(settings);
	//RELEASE(keyArray);
	//RELEASE(dictArray);
	//RELEASE(array);
	NSLog(@"out");

}

- (void) prf_save: (id) sender
{
	[NSApp stopModal];
   	[preferences close];
	[self savePreferences];
	
}

- (void) prf_add: (id) sender
{
	[todos addObject: [[Todo alloc] initWithDescription: @"New Preset" andImage:
	nil andTime: 10]];
	[prf_tableView reloadData];
	
}

- (void) prf_del: (id)sender
{
	int row = [prf_tableView selectedRow];
	[todos removeObject: [todos objectAtIndex: row]];
	[prf_tableView reloadData];
	[self tableViewSelectionDidChange: nil];
}

- (void) prf_browse: (id)sender
{
	NSOpenPanel * panel = [NSOpenPanel openPanel];
	[panel runModalForDirectory:nil
                           file:nil
                          types: [NSArray arrayWithObjects: @".tif",@"tiff",nil ]];
	NSLog( [[panel filenames] objectAtIndex: 0]);

	NSImage *img = [[NSImage alloc]  initByReferencingFile: [[panel filenames] objectAtIndex: 0]];
	[img setName: [[panel filenames] objectAtIndex: 0]];
	[[todos objectAtIndex:[prf_tableView selectedRow]] setImage: img];
	[self tableViewSelectionDidChange: nil];
	RELEASE(img);

}


-(void)tableViewSelectionDidChange:(NSNotification *)aNotification
{
	// update preferences data
	int row = [prf_tableView selectedRow];
	id todo = [todos objectAtIndex: row];
	[prf_buttonText setStringValue: [todo getDescription]];
	[prf_durationText setIntValue: [todo getTime]];
	[prf_image setImage: [todo getImage]];
	printf("tableviewselectionchenge\n");
	
}

- (void)textDidChange:(NSNotification *)tnot
{
	//in one of prf_*textview
	int row = [prf_tableView selectedRow];
        id todo = [todos objectAtIndex: row];

	[todo setDescription: [prf_buttonText stringValue]];
	[todo setTime: [prf_durationText doubleValue]];
	
	[prf_tableView reloadData];
	[self tableViewSelectionDidChange: nil];
	printf("textDidEndEditing %d\n",row);
}


// tableview data source methods:
- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
	return [todos count];
}

- (id)tableView:(NSTableView *)aTableView
objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	return [[todos objectAtIndex: rowIndex] getDescription];
}


@end
