# Manual.pm
# Copyright (c) 2006 Jonathan Rockway <jrockway@cpan.org>

package Catalyst::Manual;

use strict;
use warnings;

our $VERSION = '5.9010';

1;
__END__

=head1 NAME

Catalyst::Manual - The Catalyst developer's manual

=head1 SYNOPSIS

    perldoc Catalyst::Manual::Intro
    perldoc Catalyst::Manual::Tutorial


=head1 SEE ALSO

Install L<Task::Catalyst::Tutorial> to
install all the dependencies you need to follow along with the
Tutorial.  You can also refer to
L<Catalyst::Manual::Tutorial::Intro|Catalyst::Manual::Tutorial::01_Intro>
for more information on installation options.

Some "Getting Started" Links:

=over 4

=item *

L<Catalyst::Manual::About>

=item *

L<Catalyst::Manual::Intro>

=item *

L<Catalyst::Manual::Tutorial>

=item *

L<Catalyst::Manual::Actions>

=item *

L<Catalyst::Manual::Cookbook>

=item *

L<Catalyst::Manual::DevelopmentProcess>

=item *

L<Catalyst::Manual::ExtendingCatalyst>

=item *

L<Catalyst::Manual::Internals>

=back

=head2 Books

For additional information on Catalyst, there are currently two books available:

=over 4

=item *

The Definitive Guide to Catalyst: Writing Extendable, Scalable and
Maintainable Perl-Based Web Applications

By: Kieren Diment, Matt Trout
Available July 12, 2009
ISBN 10: 1-4302-2365-0
ISBN 13: 978-1-4302-2365-8
http://www.apress.com/book/view/9781430223658

=item *

Accelerating Perl Web Application Development

By: Jonathan Rockway
Published December, 2007
ISBN 10: 1847190952
ISBN 13: 978-1-847190-95-6
http://www.packtpub.com/catalyst-perl-web-application/book

=back

=head1 SUPPORT

Corrections or amendments may be submitted through L<the RT bug tracker|https://rt.cpan.org/Public/Dist/Display.html?Name=Catalyst-Manual>
(or L<bug-Catalyst-Manual@rt.cpan.org|mailto:bug-Catalyst-Manual@rt.cpan.org>).

There is also a mailing list available for users of this distribution, at
L<http://lists.scsys.co.uk/cgi-bin/mailman/listinfo/catalyst>.

There is also an irc channel available for users of this distribution, at
L<irc://irc.perl.org/#catalyst>.

=head1 AUTHORS

Catalyst Contributors, see L<Catalyst>

=head1 COPYRIGHT AND LICENCE

This software is copyright (c) 2006 by the Catalyst contributors.

This is free software and content; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
