#!/usr/bin/perl -w

use strict;
use Test::More tests => 18;
use Bit::Compare qw(bit);

my @t = (
 "0000" => '0',
 "0001" => '1',
 "0010" => '2',
 "0011" => '3',
 "0100" => '4',
 "0101" => '5',
 "0110" => '6',
 "0111" => '7',
 "1000" => '8',
 "1001" => '9',
 "1010" => 'a',
 "1011" => 'b',
 "1100" => 'c',
 "1101" => 'd',
 "1110" => 'e',
 "1111" => 'f',
);

my $n = scalar(@t);
while ($n--) {
    is(join("", bit($t[$n--])), $t[$n], "testing " . $t[$n + 1]);
}

my $s = bit('55c999179ad889e9924010d5e14b8ab8789148f2a3b51ce588108230122e1558');
is(length($s), "256", "length of string is ok");
is($s,
    '0101010111001001100110010001011110011010110110001000100111101001100100100100000000010000110101011110000101001011100010101011100001111000100100010100100011110010101000111011010100011100111001011000100000010000100000100011000000010010001011100001010101011000',
    "big strings are ok");

