/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.internal.storage.DocumentedStoreProvider;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.storage.xml.MimeTypeDetector;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;

public abstract class AbstractProvider
extends DocumentedStoreProvider {
    public static final String MIME_TYPE = "application/xml";
    private static final int READ_AHEAD_LIMIT = 2048;
    private static final byte[] HEADER = new byte[]{60, 63, 120, 109, 108, 32};
    protected final Map<String, String> types;

    protected AbstractProvider(String string, int n) {
        super(string);
        this.types = new HashMap<String, String>(n);
    }

    @Override
    public ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        final ByteBuffer byteBuffer = storageConnector.getStorageAs(ByteBuffer.class);
        if (byteBuffer != null) {
            if (byteBuffer.remaining() < HEADER.length) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
            for (int i = 0; i < HEADER.length; ++i) {
                if (byteBuffer.get(i) == HEADER[i]) continue;
                return ProbeResult.UNSUPPORTED_STORAGE;
            }
            byteBuffer.position(HEADER.length);
            ProbeResult probeResult = new MimeTypeDetector(this.types){

                @Override
                int read() {
                    if (byteBuffer.hasRemaining()) {
                        return byteBuffer.get();
                    }
                    this.insufficientBytes = byteBuffer.limit() != byteBuffer.capacity();
                    return -1;
                }
            }.probeContent();
            byteBuffer.position(0);
            return probeResult;
        }
        final Reader reader = storageConnector.getStorageAs(Reader.class);
        if (reader != null) {
            try {
                reader.mark(HEADER.length + 2048);
                for (int i = 0; i < HEADER.length; ++i) {
                    if (reader.read() == HEADER[i]) continue;
                    reader.reset();
                    return ProbeResult.UNSUPPORTED_STORAGE;
                }
                ProbeResult probeResult = new MimeTypeDetector(this.types){
                    private int remaining;
                    {
                        super(map);
                        this.remaining = 2048;
                    }

                    @Override
                    int read() throws IOException {
                        return --this.remaining >= 0 ? IOUtilities.readCodePoint(reader) : -1;
                    }
                }.probeContent();
                reader.reset();
                return probeResult;
            }
            catch (IOException iOException) {
                throw new DataStoreException(iOException);
            }
        }
        return ProbeResult.UNSUPPORTED_STORAGE;
    }
}

