# Generated by default/object.tt
package Paws::Kendra::SalesforceConfiguration;
  use Moose;
  has ChatterFeedConfiguration => (is => 'ro', isa => 'Paws::Kendra::SalesforceChatterFeedConfiguration');
  has CrawlAttachments => (is => 'ro', isa => 'Bool');
  has ExcludeAttachmentFilePatterns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has IncludeAttachmentFilePatterns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has KnowledgeArticleConfiguration => (is => 'ro', isa => 'Paws::Kendra::SalesforceKnowledgeArticleConfiguration');
  has SecretArn => (is => 'ro', isa => 'Str', required => 1);
  has ServerUrl => (is => 'ro', isa => 'Str', required => 1);
  has StandardObjectAttachmentConfiguration => (is => 'ro', isa => 'Paws::Kendra::SalesforceStandardObjectAttachmentConfiguration');
  has StandardObjectConfigurations => (is => 'ro', isa => 'ArrayRef[Paws::Kendra::SalesforceStandardObjectConfiguration]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::SalesforceConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::SalesforceConfiguration object:

  $service_obj->Method(Att1 => { ChatterFeedConfiguration => $value, ..., StandardObjectConfigurations => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::SalesforceConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->ChatterFeedConfiguration

=head1 DESCRIPTION

Provides configuration information for connecting to a Salesforce data
source.

=head1 ATTRIBUTES


=head2 ChatterFeedConfiguration => L<Paws::Kendra::SalesforceChatterFeedConfiguration>

Specifies configuration information for Salesforce chatter feeds.


=head2 CrawlAttachments => Bool

Indicates whether Amazon Kendra should index attachments to Salesforce
objects.


=head2 ExcludeAttachmentFilePatterns => ArrayRef[Str|Undef]

A list of regular expression patterns. Documents that match the
patterns are excluded from the index. Documents that don't match the
patterns are included in the index. If a document matches both an
exclusion pattern and an inclusion pattern, the document is not
included in the index.

The regex is applied to the name of the attached file.


=head2 IncludeAttachmentFilePatterns => ArrayRef[Str|Undef]

A list of regular expression patterns. Documents that match the
patterns are included in the index. Documents that don't match the
patterns are excluded from the index. If a document matches both an
inclusion pattern and an exclusion pattern, the document is not
included in the index.

The regex is applied to the name of the attached file.


=head2 KnowledgeArticleConfiguration => L<Paws::Kendra::SalesforceKnowledgeArticleConfiguration>

Specifies configuration information for the knowledge article types
that Amazon Kendra indexes. Amazon Kendra indexes standard knowledge
articles and the standard fields of knowledge articles, or the custom
fields of custom knowledge articles, but not both.


=head2 B<REQUIRED> SecretArn => Str

The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that
contains the key/value pairs required to connect to your Salesforce
instance. The secret must contain a JSON structure with the following
keys:

=over

=item *

authenticationUrl - The OAUTH endpoint that Amazon Kendra connects to
get an OAUTH token.

=item *

consumerKey - The application public key generated when you created
your Salesforce application.

=item *

consumerSecret - The application private key generated when you created
your Salesforce application.

=item *

password - The password associated with the user logging in to the
Salesforce instance.

=item *

securityToken - The token associated with the user account logging in
to the Salesforce instance.

=item *

username - The user name of the user logging in to the Salesforce
instance.

=back



=head2 B<REQUIRED> ServerUrl => Str

The instance URL for the Salesforce site that you want to index.


=head2 StandardObjectAttachmentConfiguration => L<Paws::Kendra::SalesforceStandardObjectAttachmentConfiguration>

Provides configuration information for processing attachments to
Salesforce standard objects.


=head2 StandardObjectConfigurations => ArrayRef[L<Paws::Kendra::SalesforceStandardObjectConfiguration>]

Specifies the Salesforce standard objects that Amazon Kendra indexes.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

