#!/usr/bin/perl

package eBay::API::XML::DataType::ExpressProductType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ExpressProductType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ExpressProductType

=head1 DESCRIPTION

Information that eBay Express collects about an eBay catalog product.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ExpressProductType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::ExternalProductIDType;
use eBay::API::XML::DataType::NameValueListArrayType;
use eBay::API::XML::DataType::Enum::ProductStateCodeType;


my @gaProperties = ( [ 'DetailsURL', 'xs:anyURI', '', '', '' ]
	, [ 'ExternalProductID', 'ns:ExternalProductIDType', ''
	     ,'eBay::API::XML::DataType::ExternalProductIDType', '1' ]
	, [ 'ItemCount', 'xs:int', '', '', '' ]
	, [ 'ItemSpecifics', 'ns:NameValueListArrayType', ''
	     ,'eBay::API::XML::DataType::NameValueListArrayType', '1' ]
	, [ 'MaxPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'MinPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'ProductReferenceID', 'xs:long', '', '', '' ]
	, [ 'ProductState', 'ns:ProductStateCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ProductStateCodeType', '' ]
	, [ 'StockPhotoURL', 'xs:anyURI', '', '', '' ]
	, [ 'Title', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDetailsURL()

Fully qualified URL for optional information about the product,
such as a movie's description or film credits. This information
is hosted through the eBay.com Web site and it cannot be edited.
Portions of the content are protected by copyright.
Applications can include this URL as a link in product search results
so that end users can view additional descriptive details about
the product. This is usually always returned when Product is returned,
but it may be safest to check for the existence of this field.

#    Argument: 'xs:anyURI'

=cut

sub setDetailsURL {
  my $self = shift;
  $self->{'DetailsURL'} = shift
}

=head2 getDetailsURL()

#    Returns: 'xs:anyURI'

=cut

sub getDetailsURL {
  my $self = shift;
  return $self->{'DetailsURL'};
}


=head2 setExternalProductID()

An ISBN or UPC value (if any) that is associated with this eBay catalog product.
Only returned when ProductDetails is set to Fine.

#    Argument: 'ns:ExternalProductIDType'

=cut

sub setExternalProductID {
  my $self = shift;
  $self->{'ExternalProductID'} = shift
}

=head2 getExternalProductID()

#    Returns: 'ns:ExternalProductIDType'

=cut

sub getExternalProductID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ExternalProductID'
		,'eBay::API::XML::DataType::ExternalProductIDType');
}


=head2 setItemCount()

Total number of active listings (on the specified Express site)
that were pre-filled based on this eBay catalog product.
Only returned when ProductDetails is set to Fine.
This does not necessarily match the number of items returned
in ItemArray (if any), because the call returns deduped items
in ItemArray.

#    Argument: 'xs:int'

=cut

sub setItemCount {
  my $self = shift;
  $self->{'ItemCount'} = shift
}

=head2 getItemCount()

#    Returns: 'xs:int'

=cut

sub getItemCount {
  my $self = shift;
  return $self->{'ItemCount'};
}


=head2 setItemSpecifics()

A list of attribute and value pairs that are included in the product's pre-
filled Item Specifics and that are applicable in Express search results. This
does not necessarily include all Item Specifics that are defined for the
product in the catalog. Typically, it returns only the top attributes (as
determined by Express). See ExternalProductID for the ISBN or UPC, if
applicable. Only returned when ProductDetails is set to Fine.

#    Argument: 'ns:NameValueListArrayType'

=cut

sub setItemSpecifics {
  my $self = shift;
  $self->{'ItemSpecifics'} = shift
}

=head2 getItemSpecifics()

#    Returns: 'ns:NameValueListArrayType'

=cut

sub getItemSpecifics {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemSpecifics'
		,'eBay::API::XML::DataType::NameValueListArrayType');
}


=head2 setMaxPrice()

Highest current price of active and ended listings on the specified
eBay site that were pre-filled based on this product.
The value is in the Express site's currency (i.e., not converted).
Round numbers might only show one zero after the decimal (e.g., 15.0).
Always returned when Product is returned. Excludes shipping costs.

#    Argument: 'ns:AmountType'

=cut

sub setMaxPrice {
  my $self = shift;
  $self->{'MaxPrice'} = shift
}

=head2 getMaxPrice()

#    Returns: 'ns:AmountType'

=cut

sub getMaxPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MaxPrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setMinPrice()

Lowest current price of active and ended listings on the specified
eBay site that were pre-filled based on the eBay catalog product.
The value is in the Express site's currency (i.e., not converted).
Round numbers might only show one zero after the decimal (e.g., 15.0).
Always returned when Product is returned. Excludes shipping costs.

#    Argument: 'ns:AmountType'

=cut

sub setMinPrice {
  my $self = shift;
  $self->{'MinPrice'} = shift
}

=head2 getMinPrice()

#    Returns: 'ns:AmountType'

=cut

sub getMinPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MinPrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setProductReferenceID()

The global reference ID for the eBay catalog product.
For GetSearchResultsExpress, only returned when ProductDetails is set to Fine.<br>
<br>
<span class="tablenote"><b>Note:</b>
This value is not the same as the ProductID used in AddItem and related calls. A
ProductID represents a particular version of a catalog product, which is
associated with a particular set of Item Specifics and other details. A
ProductReferenceID is a more generic or global reference to a catalog product,
which is useful for buy-side searching. One ProductReferenceID can be associated
with multiple ProductIDs.</span>

#    Argument: 'xs:long'

=cut

sub setProductReferenceID {
  my $self = shift;
  $self->{'ProductReferenceID'} = shift
}

=head2 getProductReferenceID()

#    Returns: 'xs:long'

=cut

sub getProductReferenceID {
  my $self = shift;
  return $self->{'ProductReferenceID'};
}


=head2 setProductState()

Indicates that the product has changed or will soon change (usually due to a migration
from one catalog to another catalog). Typically, this field is 
returned for up to 90 days for a given product. After that, the product either no 
longer returns this field or the product is no longer returned (depending on the 
state change). 
As of mid-2008, this data is primarily applicable to catalogs used by the 
US, Germany, Austria, and Switzerland sites.
Other sites may undergo catalog changes in the future.

#    Argument: 'ns:ProductStateCodeType'

=cut

sub setProductState {
  my $self = shift;
  $self->{'ProductState'} = shift
}

=head2 getProductState()

#    Returns: 'ns:ProductStateCodeType'

=cut

sub getProductState {
  my $self = shift;
  return $self->{'ProductState'};
}


=head2 setStockPhotoURL()

Fully qualified URL for a stock image (if any) that is associated with the
eBay catalog product. For GetSearchResultsExpress, only returned when ProductDetails is set to Fine.

#    Argument: 'xs:anyURI'

=cut

sub setStockPhotoURL {
  my $self = shift;
  $self->{'StockPhotoURL'} = shift
}

=head2 getStockPhotoURL()

#    Returns: 'xs:anyURI'

=cut

sub getStockPhotoURL {
  my $self = shift;
  return $self->{'StockPhotoURL'};
}


=head2 setTitle()

The title of the eBay catalog product. Always returned when Product is returned.

#    Argument: 'xs:string'

=cut

sub setTitle {
  my $self = shift;
  $self->{'Title'} = shift
}

=head2 getTitle()

#    Returns: 'xs:string'

=cut

sub getTitle {
  my $self = shift;
  return $self->{'Title'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
