/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.geo.topic;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoParserConfig
implements Serializable {
    private static final long serialVersionUID = -3167692634278575818L;
    private URL nerModelUrl = GeoParserConfig.class.getResource("en-ner-location.bin");
    private String gazetteerRestEndpoint = null;
    private static final Logger LOG = LoggerFactory.getLogger(GeoParserConfig.class);

    public GeoParserConfig() {
        this.init(this.getClass().getResourceAsStream("GeoTopicConfig.properties"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InputStream stream) {
        if (stream == null) {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(stream);
        }
        catch (IOException e) {
            LOG.warn("GeoTopicConfig.properties not found in class path");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    LOG.error("Unable to close stream: {}", (Object)ioe.getMessage());
                }
            }
        }
        this.setGazetteerRestEndpoint(props.getProperty("gazetter.rest.api", "http://localhost:8765"));
    }

    public void setNERModelPath(String path) {
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.isDirectory() || !file.exists()) {
            return;
        }
        try {
            this.nerModelUrl = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setNerModelUrl(URL url) {
        this.nerModelUrl = url;
    }

    public URL getNerModelUrl() {
        return this.nerModelUrl;
    }

    public String getGazetteerRestEndpoint() {
        return this.gazetteerRestEndpoint;
    }

    public void setGazetteerRestEndpoint(String gazetteerRestEndpoint) {
        this.gazetteerRestEndpoint = gazetteerRestEndpoint;
    }
}

