/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes;

import com.coremedia.iso.boxes.AbstractBox;
import com.googlecode.mp4parser.RequiresParseDetailAspect;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitWriterBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC3SpecificBox
extends AbstractBox {
    List<Entry> entries = new LinkedList<Entry>();
    int dataRate;
    int numIndSub;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public EC3SpecificBox() {
        super("dec3");
    }

    @Override
    protected long getContentSize() {
        long size = 2L;
        for (Entry entry : this.entries) {
            if (entry.num_dep_sub > 0) {
                size += 4L;
                continue;
            }
            size += 3L;
        }
        return size;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        BitReaderBuffer brb = new BitReaderBuffer(content);
        this.dataRate = brb.readBits(13);
        this.numIndSub = brb.readBits(3) + 1;
        int i = 0;
        while (i < this.numIndSub) {
            Entry e = new Entry();
            e.fscod = brb.readBits(2);
            e.bsid = brb.readBits(5);
            e.bsmod = brb.readBits(5);
            e.acmod = brb.readBits(3);
            e.lfeon = brb.readBits(1);
            e.reserved = brb.readBits(3);
            e.num_dep_sub = brb.readBits(4);
            if (e.num_dep_sub > 0) {
                e.chan_loc = brb.readBits(9);
            } else {
                e.reserved2 = brb.readBits(1);
            }
            this.entries.add(e);
            ++i;
        }
    }

    @Override
    protected void getContent(ByteBuffer bb) throws IOException {
        BitWriterBuffer bwb = new BitWriterBuffer(bb);
        bwb.writeBits(this.dataRate, 13);
        bwb.writeBits(this.entries.size() - 1, 3);
        for (Entry e : this.entries) {
            bwb.writeBits(e.fscod, 2);
            bwb.writeBits(e.bsid, 5);
            bwb.writeBits(e.bsmod, 5);
            bwb.writeBits(e.acmod, 3);
            bwb.writeBits(e.lfeon, 1);
            bwb.writeBits(e.reserved, 3);
            bwb.writeBits(e.num_dep_sub, 4);
            if (e.num_dep_sub > 0) {
                bwb.writeBits(e.chan_loc, 9);
                continue;
            }
            bwb.writeBits(e.reserved2, 1);
        }
    }

    public List<Entry> getEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries;
    }

    /*
     * WARNING - void declaration
     */
    public void setEntries(List<Entry> list) {
        void entries;
        List<Entry> list2 = list;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, list2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.entries = entries;
    }

    /*
     * WARNING - void declaration
     */
    public void addEntry(Entry entry) {
        void entry2;
        Entry entry3 = entry;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, (Object)this, (Object)this, entry3);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.entries.add((Entry)entry2);
    }

    public int getDataRate() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.dataRate;
    }

    /*
     * WARNING - void declaration
     */
    public void setDataRate(int n) {
        void dataRate;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, (Object)this, (Object)this, Conversions.intObject(n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.dataRate = dataRate;
    }

    public int getNumIndSub() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.numIndSub;
    }

    /*
     * WARNING - void declaration
     */
    public void setNumIndSub(int n) {
        void numIndSub;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, (Object)this, (Object)this, Conversions.intObject(n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.numIndSub = numIndSub;
    }

    static {
        EC3SpecificBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EC3SpecificBox.java", EC3SpecificBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEntries", "com.googlecode.mp4parser.boxes.EC3SpecificBox", "", "", "", "java.util.List"), 85);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEntries", "com.googlecode.mp4parser.boxes.EC3SpecificBox", "java.util.List", "entries", "", "void"), 89);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addEntry", "com.googlecode.mp4parser.boxes.EC3SpecificBox", "com.googlecode.mp4parser.boxes.EC3SpecificBox$Entry", "entry", "", "void"), 93);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDataRate", "com.googlecode.mp4parser.boxes.EC3SpecificBox", "", "", "", "int"), 97);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDataRate", "com.googlecode.mp4parser.boxes.EC3SpecificBox", "int", "dataRate", "", "void"), 101);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNumIndSub", "com.googlecode.mp4parser.boxes.EC3SpecificBox", "", "", "", "int"), 105);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNumIndSub", "com.googlecode.mp4parser.boxes.EC3SpecificBox", "int", "numIndSub", "", "void"), 109);
    }

    public static class Entry {
        public int fscod;
        public int bsid;
        public int bsmod;
        public int acmod;
        public int lfeon;
        public int reserved;
        public int num_dep_sub;
        public int chan_loc;
        public int reserved2;

        public String toString() {
            return "Entry{fscod=" + this.fscod + ", bsid=" + this.bsid + ", bsmod=" + this.bsmod + ", acmod=" + this.acmod + ", lfeon=" + this.lfeon + ", reserved=" + this.reserved + ", num_dep_sub=" + this.num_dep_sub + ", chan_loc=" + this.chan_loc + ", reserved2=" + this.reserved2 + '}';
        }
    }
}

