#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patch to:
#   - Add explicit casts to silence warnings.
#   - Fixup includes.
#   - Move to uuconfig.h.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- usrcP/uuid/parse.c	Sun Jan 14 15:29:18 2024
+++ ulib/uuid/parse.c	Sun Jan 14 15:36:21 2024
@@ -32,14 +32,9 @@
  * %End-Header%
  */
 
-#include "config.h"
-#include <stdlib.h>
-#include <stdio.h>
-#include <ctype.h>
-#include <string.h>
+#include "uuconfig.h"
+#include "uuid/uuidP.h"
 
-#include "uuidP.h"
-
 int myuuid_parse(const char *in, myuuid_t uu)
 {
 	struct myuuid	uuid;
@@ -64,15 +59,15 @@
 			return -1;
 	}
 	uuid.time_low = strtoul(in, NULL, 16);
-	uuid.time_mid = strtoul(in+9, NULL, 16);
-	uuid.time_hi_and_version = strtoul(in+14, NULL, 16);
-	uuid.clock_seq = strtoul(in+19, NULL, 16);
+	uuid.time_mid = (myuint16_t)strtoul(in+9, NULL, 16);
+	uuid.time_hi_and_version = (myuint16_t)strtoul(in+14, NULL, 16);
+	uuid.clock_seq = (myuint16_t)strtoul(in+19, NULL, 16);
 	cp = in+24;
 	buf[2] = 0;
 	for (i=0; i < 6; i++) {
 		buf[0] = *cp++;
 		buf[1] = *cp++;
-		uuid.node[i] = strtoul(buf, NULL, 16);
+		uuid.node[i] = (myuint8_t)strtoul(buf, NULL, 16);
 	}
 
 	myuuid_pack(&uuid, uu);

