package Sah::PSchemaBundle;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-30'; # DATE
our $DIST = 'Sah-PSchemaBundle'; # DIST
our $VERSION = '0.1.1'; # VERSION

1;
# ABSTRACT: Convention for Sah-PSchemaBundle-* distribution

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::PSchemaBundle - Convention for Sah-PSchemaBundle-* distribution

=head1 VERSION

This document describes version 0.1.1 of Sah::PSchemaBundle (from Perl distribution Sah-PSchemaBundle), released on 2024-05-30.

=head1 DESCRIPTION

A C<Sah-PSchemaBundle-*> distribution contains one or more related L<Sah>
parameterized schemas.

=over

=item * Put each individual schema in C<< Sah::PSchema::<NAME> >> package

Metadata must be returned by the C<meta> method.

Schema must be returned by the C<get_schema> method, which accepts:

 ($self, \%args [ , \%merge ])

=back

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-PSchemaBundle>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-PSchemaBundle>.

=head1 SEE ALSO

L<Sah::PSchema>, a convenient module to retrieve parameterized Sah schemas.

C<Sah::PSchemaBundle::*>, distributions containing parameterized schemas.

L<Sah::SchemaBundle::*> and L<Sah::Schema::*>, for regular, non-parameterized
schemas.

L<Sah> and L<Data::Sah>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-PSchemaBundle>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
