# IUP::Cbox example

use strict;
use warnings;

use IUP ':all';

my $img_bits1 = [
 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1
,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
,2,2,2,0,2,0,2,0,2,2,0,2,2,2,0,0,0,2,2,2,0,0,2,0,2,2,0,0,0,2,2,2
,2,2,2,0,2,0,0,2,0,0,2,0,2,0,2,2,2,0,2,0,2,2,0,0,2,0,2,2,2,0,2,2
,2,2,2,0,2,0,2,2,0,2,2,0,2,2,2,2,2,0,2,0,2,2,2,0,2,0,2,2,2,0,2,2
,2,2,2,0,2,0,2,2,0,2,2,0,2,2,0,0,0,0,2,0,2,2,2,0,2,0,0,0,0,0,2,2
,2,2,2,0,2,0,2,2,0,2,2,0,2,0,2,2,2,0,2,0,2,2,2,0,2,0,2,2,2,2,2,2
,2,2,2,0,2,0,2,2,0,2,2,0,2,0,2,2,2,0,2,0,2,2,0,0,2,0,2,2,2,0,2,2
,2,2,2,0,2,0,2,2,0,2,2,0,2,2,0,0,0,0,2,2,0,0,2,0,2,2,0,0,0,2,2,2
,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2
,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,0,2,2,2,2,2,2,2,2
,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,2,2,2,2,2,2
,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
];

my $img_bits2 = [
 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2
,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2
,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2
,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2
,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2
,2,2,2,2,2,2,2,2,2,2,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2
,2,2,2,2,2,2,2,2,2,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2
,2,2,2,2,2,2,2,2,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2
,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
,3,3,3,0,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
,3,3,3,0,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
,3,3,3,0,3,0,3,0,3,3,0,3,3,3,1,1,0,3,3,3,0,0,3,0,3,3,0,0,0,3,3,3
,3,3,3,0,3,0,0,3,0,0,3,0,3,0,1,1,3,0,3,0,3,3,0,0,3,0,3,3,3,0,3,3
,3,3,3,0,3,0,3,3,0,3,3,0,3,3,1,1,3,0,3,0,3,3,3,0,3,0,3,3,3,0,3,3
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,3,3,3,0,3,0,3,3,0,3,3,0,3,0,1,1,3,0,3,0,3,3,0,0,3,0,3,3,3,0,3,3
,3,3,3,0,3,0,3,3,0,3,3,0,3,3,1,1,0,0,3,3,0,0,3,0,3,3,0,0,0,3,3,3
,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3
,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,0,3,3,3,0,3,3,3,3,3,3,3,3
,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,0,0,0,3,3,3,3,3,3,3,3,3
,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
,2,2,2,2,2,2,2,3,3,3,3,3,3,3,1,1,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2
,2,2,2,2,2,2,3,3,3,3,3,3,3,3,1,1,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2
,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2
,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2
,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
];

my $mat = IUP::Matrix->new(
            NUMCOL         => "1",
            NUMLIN         => "3",
            NUMCOL_VISIBLE => "1",
            NUMLIN_VISIBLE => "3",
            EXPAND         => "NO",
            SCROLLBAR      => "NO",
            CX             => "600",
            CY             => "250",
            BGCOLOR        => "255 255 255",

            "BGCOLOR1:0" => "255 128 0",
            "BGCOLOR2:1" => "255 128 0",
            "FGCOLOR2:0" => "255 0 128",
            "FGCOLOR1:1" => "255 0 128",

            "0:0" => "Inflation",
            "1:0" => "Medicine",
            "2:0" => "Food",
            "3:0" => "Energy",
            "0:1" => "January 2000",
            "1:1" => "5.6",
            "2:1" => "2.2",
            "3:1" => "7.2"
);

my $tree = IUP::Tree->new(
            FONT=>"COURIER_NORMAL_10",
            NAME=>"Figures",
            ADDBRANCH=>"3D",
            ADDBRANCH=>"2D",
            ADDLEAF1=>"trapeze",
            ADDBRANCH1=>"parallelogram",
            ADDLEAF2=>"diamond",
            ADDLEAF2=>"square",
            ADDBRANCH4=>"triangle",
            ADDLEAF5=>"scalenus",
            ADDLEAF5=>"isosceles",
            ADDLEAF5=>"equilateral",
            RASTERSIZE=>"180x180",
            VALUE=>"6",
            CTRL=>"ON",
            SHIFT=>"ON",
            CX=>600,
            CY=>10,
            ADDEXPANDED=>"NO"
);

my $img1 = IUP::Image->new( WIDTH=>32, HEIGHT=>32, pixels=>$img_bits1, colors=>["0 0 0", "BGCOLOR", "255 0 0"] );

my $img2 = IUP::Image->new( WIDTH=>32, HEIGHT=>32, pixels=>$img_bits2, colors=>["0 0 0", "0 255 0", "BGCOLOR", "255 0 0"] );

my $frm1 = IUP::Frame->new( child=>
             IUP::Vbox->new( child=> [
               IUP::Button->new( TITLE=>"Button Text", CINDEX=>1 ),
               IUP::Button->new( IMAGE=>$img1, CINDEX=>2 ),
               IUP::Button->new( IMAGE=>$img1, IMPRESS=>$img2, CINDEX=>3 ),
             ]),
             TITLE=>"IUP::Button", CX=>10, CY=>180 );

my $frm2 = IUP::Frame->new( child=>
             IUP::Vbox->new( child=> [
               IUP::Label->new( TITLE=>"Label Text", CINDEX=>1 ),
               IUP::Label->new( SEPARATOR=>"HORIZONTAL", CINDEX=>2 ),
               IUP::Label->new( IMAGE=>$img1, CINDEX=>3 ),
             ]),
             TITLE=>"IUP::Label", CX=>200, CY=>250 );

my $frm3 = IUP::Frame->new( child=>
             IUP::Vbox->new( child=> [
               IUP::Toggle->new( TITLE=>"Toggle Text", VALUE=>"ON", CINDEX=>1 ),
               IUP::Toggle->new( IMAGE=>$img1, IMPRESS=>$img2, CINDEX=>2 ),
               IUP::Frame->new( child=>
                 IUP::Radio->new( TITLE=>"IUP::Radio", child=>
                   IUP::Vbox->new( child=>[
                     IUP::Toggle->new( TITLE=>"Toggle Text", CINDEX=>3 ),
                     IUP::Toggle->new( TITLE=>"Toggle Text", CINDEX=>4 ),
                   ]),
                 )
               ),
             ]),
           TITLE=>"IUP::Toggle", CX=>400, CY=>250 );

my $text1 = IUP::Text->new(
              VALUE=>"IUP::Text Text",
              SIZE=>"80x",
              CINDEX=>"1",
              CX=>10,
              CY=>100 );

my $ml1 = IUP::Text->new(
              MULTILINE=>"YES",
              VALUE=>"IUP::Text Multiline Text\nSecond Line\nThird Line",
              SIZE=>"80x60",
              CINDEX=>1,
              CX=>200,
              CY=>100 );

my $list1 = IUP::List->new(
              VALUE=>1,
              "1"=>"Item 1 Text",
              "2"=>"Item 2 Text",
              "3"=>"Item 3 Text",
              CINDEX=>1,
              CX=>10,
              CY=>10 );

my $list2 = IUP::List->new(
              DROPDOWN=>"YES",
              VALUE=>2,
              "1"=>"Item 1 Text",
              "2"=>"Item 2 Text",
              "3"=>"Item 3 Text",
              CINDEX=>2,
              CX=>200,
              CY=>10 );

my $list3 = IUP::List->new(
              EDITBOX=>"YES",
              VALUE=>3,
              "1"=>"Item 1 Text",
              "2"=>"Item 2 Text",
              "3"=>"Item 3 Text",
              CINDEX=>3,
              CX=>400,
              CY=>10 );

my $cnv1 = IUP::Canvas->new(
              RASTERSIZE=>"100x100",
              POSX=>0,
              POSY=>0,
              BGCOLOR=>"128 255 0",
              CX=>400,
              CY=>150 );

my $ctrl1 = IUP::Val->new( CX=>600, CY=>200 );

my $cbox = IUP::Cbox->new( SIZE=>"480x200", 
             child=>[$text1, $ml1, $list1, $list2, $list3, $cnv1, $ctrl1, $tree, $mat, $frm1, $frm2, $frm3 ]);
    
my $hbox = IUP::Hbox->new( child=>$cbox, MARGIN=>"10x10" );

my $dlg = IUP::Dialog->new( child=>$hbox, TITLE=> "Cbox Test" );

$dlg->ShowXY(IUP_CENTER, IUP_CENTER);

IUP->MainLoop();
