################################################################################
#
#  mktests.PL -- generate test files for Devel::PPPort
#
################################################################################
#
#  Version 3.x, Copyright (C) 2004-2013, Marcus Holland-Moritz.
#  Version 2.x, Copyright (C) 2001, Paul Marquess.
#  Version 1.x, Copyright (C) 1999, Kenneth Albanowski.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the same terms as Perl itself.
#
################################################################################

use strict;
BEGIN { $^W = 1; }
require "./parts/ppptools.pl";

my $template = do { local $/; <DATA> };

generate_tests();

sub generate_tests
{
  my @tests;
  my $file;

  for $file (all_files_in_dir('parts/inc')) {
    my($testfile) = $file =~ /(\w+)\.?$/;  # VMS has a trailing dot
    $testfile = "t/$testfile.t";

    my $spec = parse_partspec($file);
    my $plan = 0;

    if (exists $spec->{tests}) {
      exists $spec->{OPTIONS}{tests} &&
      exists $spec->{OPTIONS}{tests}{plan}
          or die "No plan for tests in $file\n";

      print "generating $testfile\n";

      my $tmpl = $template;
      my $canonfile = $file;
      $canonfile =~ tr!\\!/!; # MSWin32 use backslashes
      $tmpl =~ s/__SOURCE__/$canonfile/mg;
      $tmpl =~ s/__PLAN__/$spec->{OPTIONS}{tests}{plan}/mg;
      $tmpl =~ s/^__TESTS__$/$spec->{tests}/mg;

      open FH, ">$testfile" or die "$testfile: $!\n";
      binmode FH;
      print FH $tmpl;
      close FH;

      push @tests, $testfile;
    }
  }

  return @tests;
}

__DATA__
################################################################################
#
#            !!!!!   Do NOT edit this file directly!   !!!!!
#
#            Edit mktests.PL and/or __SOURCE__ instead.
#
#  This file was automatically generated from the definition files in the
#  parts/inc/ subdirectory by mktests.PL. To learn more about how all this
#  works, please read the F<HACKERS> file that came with this distribution.
#
################################################################################

BEGIN {
  if ($ENV{'PERL_CORE'}) {
    chdir 't' if -d 't';
    @INC = ('../lib', '../ext/Devel-PPPort/t', '../ext/Devel-PPPort/parts/inc') if -d '../lib' && -d '../ext';
    require Config; import Config;
    use vars '%Config';
    if (" $Config{'extensions'} " !~ m[ Devel/PPPort ]) {
      print "1..0 # Skip -- Perl configured without Devel::PPPort module\n";
      exit 0;
    }
  }
  else {
    unshift @INC, 't', 'parts/inc';
  }

  sub load {
    eval "use Test";
    require 'testutil.pl' if $@;
    require 'inctools';
  }

  if (__PLAN__) {
    load();
    plan(tests => __PLAN__);
  }
}

use Devel::PPPort;
use strict;
BEGIN { $^W = 1; }

package Devel::PPPort;
use vars '@ISA';
require DynaLoader;
@ISA = qw(DynaLoader);
bootstrap Devel::PPPort;

package main;

__TESTS__
