package XAS::Docs::Contributions;

use strict;
use warnings;

our $VERSION = '0.01';

1;

__END__

=head1 NAME

XAS::Docs::Contributions - How to contribute to XAS

So you have used the framework and liked what you saw and want to contribute 
back. For that, thanks. Contributions are gladly accepted when they follow
the below guide lines.

=head1 CONTRIBUTIONS

All contributed code, documentation and patches will be licensed under the 
Artistic License v2.0, just like the rest of the code base. This is
known as the L<"inbound=outbound"|http://ebb.org/bkuhn/blog/2014/06/09/do-not-need-cla.html>
principle. 

Additionally, any contributed modules, code or documentation, must have an 
author and copyright/license attributions, like the ones at the bottom of this 
document. That way, I know who contributed what.

=head1 DONATIONS

I will gladly accept money donations. You can donate thru L<PayPal|https://www.paypal.com/home>. My email
is in the code. The donation doesn't obligate me in any way or fashion to
provide a service. Please use the "Friends and Family" option when sending the
donation.

=head1 AUTHOR

Kevin L. Esteb, E<lt>kevin@kesteb.usE<gt>

=head1 LICENSE AND COPYRIGHT

Copyright (c) 2015 Kevin L. Esteb

This is free software; you can redistribute it and/or modify it under
the terms of the Artistic License 2.0. For details, see the full text
of the license at http://www.perlfoundation.org/artistic_license_2_0.

=cut
