/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.graphics.DiagramComponent;
import org.stathissideris.ascii2image.graphics.DiagramShape;
import org.stathissideris.ascii2image.graphics.ShapePoint;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.TextGrid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDiagramShape
extends DiagramComponent {
    private static final boolean DEBUG = false;
    private ArrayList<DiagramShape> shapes = new ArrayList();

    public static void main(String[] stringArray) {
    }

    public static DiagramComponent createFromBoundaryCells(TextGrid textGrid, CellSet cellSet, int n, int n2) {
        return CompositeDiagramShape.createOpenFromBoundaryCells(textGrid, cellSet, n, n2, false);
    }

    public static DiagramComponent createOpenFromBoundaryCells(TextGrid textGrid, CellSet cellSet, int n, int n2, boolean bl) {
        if (cellSet.getType(textGrid) != 1) {
            throw new IllegalArgumentException("This shape is closed and cannot be handled by this method");
        }
        if (cellSet.size() == 0) {
            return null;
        }
        CompositeDiagramShape compositeDiagramShape = new CompositeDiagramShape();
        TextGrid textGrid2 = new TextGrid(textGrid.getWidth(), textGrid.getHeight());
        textGrid.copyCellsTo(cellSet, textGrid2);
        CellSet cellSet2 = new CellSet();
        ArrayList<DiagramShape> arrayList = new ArrayList<DiagramShape>(100);
        for (Object object : cellSet) {
            if (!textGrid2.isLinesEnd((TextGrid.Cell)object)) continue;
            CellSet object2 = textGrid2.followCell((TextGrid.Cell)object);
            arrayList.addAll(CompositeDiagramShape.growEdgesFromCell(textGrid2, n, n2, bl, object2.getFirst(), object, cellSet2));
            break;
        }
        boolean bl2 = false;
        for (DiagramShape diagramShape : arrayList) {
            if (!diagramShape.isStrokeDashed()) continue;
            bl2 = true;
        }
        for (DiagramShape diagramShape : arrayList) {
            if (bl2) {
                diagramShape.setStrokeDashed(true);
            }
            compositeDiagramShape.addToShapes(diagramShape);
        }
        return compositeDiagramShape;
    }

    private static List<DiagramShape> growEdgesFromCell(TextGrid textGrid, int n, int n2, boolean bl, TextGrid.Cell cell, TextGrid.Cell cell2, CellSet cellSet) {
        ArrayList<DiagramShape> arrayList = new ArrayList<DiagramShape>(50);
        cellSet.add(cell2);
        DiagramShape diagramShape = new DiagramShape();
        diagramShape.addToPoints(CompositeDiagramShape.makePointForCell(cell2, textGrid, n, n2, bl));
        if (textGrid.cellContainsDashedLineChar(cell2)) {
            diagramShape.setStrokeDashed(true);
        }
        boolean bl2 = false;
        while (!bl2) {
            CellSet cellSet2;
            cellSet.add(cell);
            if (textGrid.isPointCell(cell)) {
                diagramShape.addToPoints(CompositeDiagramShape.makePointForCell(cell, textGrid, n, n2, bl));
            }
            if (textGrid.cellContainsDashedLineChar(cell)) {
                diagramShape.setStrokeDashed(true);
            }
            if (textGrid.isLinesEnd(cell)) {
                bl2 = true;
            }
            if ((cellSet2 = textGrid.followCell(cell, cell2)).size() == 1) {
                cell2 = cell;
                cell = cellSet2.getFirst();
                continue;
            }
            if (cellSet2.size() <= 1) continue;
            bl2 = true;
            for (TextGrid.Cell cell3 : cellSet2) {
                arrayList.addAll(CompositeDiagramShape.growEdgesFromCell(textGrid, n, n2, bl, cell3, cell, cellSet));
            }
        }
        arrayList.add(diagramShape);
        return arrayList;
    }

    public DiagramComponent connectLines() {
        CompositeDiagramShape compositeDiagramShape = new CompositeDiagramShape();
        ArrayList<DiagramShape> arrayList = new ArrayList<DiagramShape>();
        for (DiagramShape diagramShape : this.shapes) {
            if (diagramShape.getPoints().size() != 2) continue;
            arrayList.add(diagramShape);
        }
        Iterator<DiagramShape> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            DiagramShape diagramShape;
            diagramShape = iterator.next();
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                DiagramShape diagramShape2 = iterator.next();
                ShapePoint shapePoint = null;
                ShapePoint shapePoint2 = null;
                ShapePoint shapePoint3 = null;
                if (diagramShape.getPoint(0).equals(diagramShape2.getPoint(0))) {
                    shapePoint = diagramShape.getPoint(0);
                    shapePoint2 = diagramShape.getPoint(1);
                    shapePoint3 = diagramShape2.getPoint(1);
                }
                if (diagramShape.getPoint(0).equals(diagramShape2.getPoint(1))) {
                    shapePoint = diagramShape.getPoint(0);
                    shapePoint2 = diagramShape.getPoint(1);
                    shapePoint3 = diagramShape2.getPoint(0);
                }
                if (diagramShape.getPoint(1).equals(diagramShape2.getPoint(0))) {
                    shapePoint = diagramShape.getPoint(1);
                    shapePoint2 = diagramShape.getPoint(0);
                    shapePoint3 = diagramShape2.getPoint(1);
                }
                if (diagramShape.getPoint(1).equals(diagramShape2.getPoint(1))) {
                    shapePoint = diagramShape.getPoint(1);
                    shapePoint2 = diagramShape.getPoint(0);
                    shapePoint3 = diagramShape2.getPoint(0);
                }
                if (shapePoint == null) continue;
            }
        }
        return compositeDiagramShape;
    }

    public void connectEndsToAnchors(TextGrid textGrid, Diagram diagram) {
        for (DiagramShape diagramShape : this.shapes) {
            if (diagramShape.isClosed()) continue;
            diagramShape.connectEndsToAnchors(textGrid, diagram);
        }
    }

    private static DiagramShape makeLine(TextGrid textGrid, TextGrid.Cell cell, TextGrid.Cell cell2, int n, int n2) {
        int n3;
        DiagramShape diagramShape = new DiagramShape();
        if (textGrid.isHorizontalLine(cell)) {
            if (cell.isWestOf(cell2)) {
                diagramShape.addToPoints(new ShapePoint(Diagram.getCellMinX(cell, n), Diagram.getCellMidY(cell, n2)));
            } else {
                diagramShape.addToPoints(new ShapePoint(Diagram.getCellMaxX(cell, n), Diagram.getCellMidY(cell, n2)));
            }
        } else if (textGrid.isVerticalLine(cell)) {
            if (cell.isNorthOf(cell2)) {
                diagramShape.addToPoints(new ShapePoint(Diagram.getCellMidX(cell, n), Diagram.getCellMinY(cell, n2)));
            } else {
                diagramShape.addToPoints(new ShapePoint(Diagram.getCellMidX(cell, n), Diagram.getCellMaxY(cell, n2)));
            }
        } else {
            n3 = textGrid.isRoundCorner(cell) ? 1 : 0;
            diagramShape.addToPoints(new ShapePoint(Diagram.getCellMidX(cell, n), Diagram.getCellMidY(cell, n2), n3));
        }
        if (textGrid.isHorizontalLine(cell2)) {
            if (cell.isWestOf(cell)) {
                diagramShape.addToPoints(new ShapePoint(Diagram.getCellMinX(cell2, n), Diagram.getCellMidY(cell2, n2)));
            } else {
                diagramShape.addToPoints(new ShapePoint(Diagram.getCellMaxX(cell2, n), Diagram.getCellMidY(cell2, n2)));
            }
        } else if (textGrid.isVerticalLine(cell2)) {
            if (cell.isNorthOf(cell)) {
                diagramShape.addToPoints(new ShapePoint(Diagram.getCellMidX(cell2, n), Diagram.getCellMinY(cell2, n2)));
            } else {
                diagramShape.addToPoints(new ShapePoint(Diagram.getCellMidX(cell2, n), Diagram.getCellMaxY(cell2, n2)));
            }
        } else {
            n3 = textGrid.isRoundCorner(cell2) ? 1 : 0;
            diagramShape.addToPoints(new ShapePoint(Diagram.getCellMidX(cell2, n), Diagram.getCellMidY(cell2, n2), n3));
        }
        return diagramShape;
    }

    public void addToShapes(DiagramShape diagramShape) {
        this.shapes.add(diagramShape);
    }

    private Iterator getShapesIterator() {
        return this.shapes.iterator();
    }

    public void scale(float f) {
        Iterator iterator = this.getShapesIterator();
        while (iterator.hasNext()) {
            DiagramShape diagramShape = (DiagramShape)iterator.next();
            diagramShape.scale(f);
        }
    }

    public ArrayList getShapes() {
        return this.shapes;
    }
}

