/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eps;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.eps.PostScriptCommandCurveTo;
import net.sourceforge.plantuml.eps.PostScriptCommandLineTo;
import net.sourceforge.plantuml.eps.PostScriptCommandMacro;
import net.sourceforge.plantuml.eps.PostScriptCommandMoveTo;
import net.sourceforge.plantuml.eps.PostScriptCommandQuadTo;
import net.sourceforge.plantuml.eps.PostScriptCommandRaw;
import net.sourceforge.plantuml.eps.PostScriptData;

public class EpsGraphicsMacro
extends EpsGraphics {
    private final PostScriptData data = new PostScriptData();
    private final PostScriptCommandMacro rquadto = new PostScriptCommandMacro("rquadto");
    private double posX;
    private double posY;
    private int macroCpt;
    private final Map<PostScriptCommandMacro, String> macros = new HashMap<PostScriptCommandMacro, String>();
    private PostScriptCommandMacro macroInProgress = null;

    public EpsGraphicsMacro() {
        this.rquadto.add(new PostScriptCommandRaw("3 index 3 index 4 2 roll rcurveto", true));
    }

    protected void append(String string, boolean bl) {
        if (bl && string.indexOf("  ") != -1) {
            throw new IllegalArgumentException(string);
        }
        this.data.add(new PostScriptCommandRaw(string, bl));
    }

    protected String getBodyString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rquadto.getPostStringDefinition());
        for (PostScriptCommandMacro postScriptCommandMacro : this.macros.keySet()) {
            stringBuilder.append(postScriptCommandMacro.getPostStringDefinition());
        }
        stringBuilder.append(this.data.toPostString());
        return stringBuilder.toString();
    }

    public void newpath() {
        this.append("0 setlinewidth", true);
        this.append("[] 0 setdash", true);
        this.appendColor(this.getColor());
        this.append("newpath", true);
    }

    public void closepath() {
        this.macroInProgress.add(new PostScriptCommandRaw("closepath", true));
        this.closeMacro();
    }

    public void fill(int n) {
        if (n == 0) {
            this.append("eofill", true);
        } else if (n == 1) {
            this.append("fill", true);
        }
    }

    public void moveto(double d, double d2) {
        this.data.add(new PostScriptCommandMoveTo(d, d2));
        this.posX = d;
        this.posY = d2;
        this.openMacro();
        this.ensureVisible(d, d2);
    }

    public void lineto(double d, double d2) {
        PostScriptCommandLineTo postScriptCommandLineTo = new PostScriptCommandLineTo(d - this.posX, d2 - this.posY);
        this.macroInProgress.add(postScriptCommandLineTo);
        this.posX = d;
        this.posY = d2;
        this.ensureVisible(d, d2);
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
        PostScriptCommandCurveTo postScriptCommandCurveTo = new PostScriptCommandCurveTo(d - this.posX, d2 - this.posY, d3 - this.posX, d4 - this.posY, d5 - this.posX, d6 - this.posY);
        this.macroInProgress.add(postScriptCommandCurveTo);
        this.posX = d5;
        this.posY = d6;
        this.ensureVisible(d, d2);
        this.ensureVisible(d3, d4);
        this.ensureVisible(d5, d6);
    }

    public void quadto(double d, double d2, double d3, double d4) {
        PostScriptCommandQuadTo postScriptCommandQuadTo = new PostScriptCommandQuadTo(d - this.posX, d2 - this.posY, d3 - this.posX, d4 - this.posY);
        this.macroInProgress.add(postScriptCommandQuadTo);
        this.posX = d3;
        this.posY = d4;
        this.ensureVisible(d, d2);
        this.ensureVisible(d3, d4);
    }

    private void openMacro() {
        if (this.macroInProgress != null) {
            throw new IllegalStateException();
        }
        this.macroInProgress = new PostScriptCommandMacro(this.macroName());
    }

    private String macroName() {
        return "P$" + Integer.toString(this.macroCpt, 36);
    }

    private void closeMacro() {
        if (this.macroInProgress == null) {
            throw new IllegalStateException();
        }
        String string = this.macros.get(this.macroInProgress);
        if (string == null) {
            this.macros.put(this.macroInProgress, this.macroInProgress.getName());
            this.append(this.macroName(), true);
            ++this.macroCpt;
        } else {
            this.append(string, true);
        }
        this.macroInProgress = null;
    }

    protected void epsHLine(double d, double d2, double d3) {
        this.append(EpsGraphicsMacro.format(d) + " " + EpsGraphicsMacro.format(d2) + " moveto", true);
        int n = (int)((d3 - d2) / (this.getDashVisible() + this.getDashSpace()));
        double d4 = d2 + (double)n * (this.getDashVisible() + this.getDashSpace());
        double d5 = d3 - d4;
        if (d5 > this.getDashVisible()) {
            d5 = this.getDashVisible();
            ++n;
            d5 = 0.0;
        }
        this.append(n + "{", true);
        this.append("0 " + EpsGraphicsMacro.format(this.getDashVisible()) + " rlineto", true);
        this.append("0 " + EpsGraphicsMacro.format(this.getDashSpace()) + " rmoveto", true);
        this.append("} repeat", true);
        if (d5 > 0.0) {
            this.append("0 " + EpsGraphicsMacro.format(d5) + " rlineto", true);
        }
    }

    protected void epsVLine(double d, double d2, double d3) {
        this.append(EpsGraphicsMacro.format(d2) + " " + EpsGraphicsMacro.format(d) + " moveto", true);
        int n = (int)((d3 - d2) / (this.getDashVisible() + this.getDashSpace()));
        double d4 = d2 + (double)n * (this.getDashVisible() + this.getDashSpace());
        double d5 = d3 - d4;
        if (d5 > this.getDashVisible()) {
            d5 = this.getDashVisible();
            ++n;
            d5 = 0.0;
        }
        this.append(n + "{", true);
        this.append(EpsGraphicsMacro.format(this.getDashVisible()) + " 0 rlineto", true);
        this.append(EpsGraphicsMacro.format(this.getDashSpace()) + " 0 rmoveto", true);
        this.append("} repeat", true);
        if (d5 > 0.0) {
            this.append(EpsGraphicsMacro.format(d5) + " 0 rlineto", true);
        }
    }
}

