use strict;
use warnings;

use Test::More;
use Test::Warnings;

use TimeSeries::AdaptiveFilter qw/filter/;

ok filter(), "constructed with defaults";

# my birthday. Why not? :)
my $base_time = 413683200;

my @data_samples = (
  [413683200, 100.040503989431],
  [413683201, 100.056667660768],
  [413683202, 100.063685585849],
  [413683203, 100.074391654802],
  [413683204, 100.062160225197],
  [413683205, 100.012034217247],
  [413683206, 100.008994480395],
  [413683207, 100.031487323986],
  [413683208, 100.005751657419],
  [413683209, 100.071608472631],
  [413683210, 100.044012881979],
  [413683211, 100.004450379608],
  [413683212, 100.000375565591],
  [413683213, 100.080000127636],
  [413683214, 100.07850197019],
  [413683215, 100.02550795406],
  [413683216, 100.047248739436],
  [413683217, 100.076160044572],
  [413683218, 100.004250392241],
  [413683219, 100.057398753235],
  [413683220, 100.065474249091],
  [413683221, 100.069303845629],
  [413683222, 100.015665250866],
  [413683223, 100.013942155727],
  [413683224, 100.042610121939],
  [413683225, 100.094428485631],
  [413683226, 100.011819301932],
  [413683227, 100.092759311815],
  [413683228, 100.025411921062],
  [413683229, 100.024783216103],
  [413683230, 100.096320962766],
  [413683231, 100.038322058747],
  [413683232, 100.017740864443],
  [413683233, 100.029846008941],
  [413683234, 100.057725432001],
  [413683235, 100.073926687741],
  [413683236, 100.079909168622],
  [413683237, 100.08990480206],
  [413683238, 100.014523962627],
  [413683239, 100.032393287681],
  [413683240, 100.038178651686],
  [413683241, 100.036175647292],
  [413683242, 100.002944268001],
  [413683243, 100.039484582036],
  [413683244, 100.04530369457],
  [413683245, 100.060245263779],
  [413683246, 100.032340832227],
  [413683247, 100.093740400216],
  [413683248, 100.077544342879],
  [413683249, 100.093054409394],
  [413683250, 100.017884697699],
  [413683251, 100.069467213818],
  [413683252, 100.094161040045],
  [413683253, 100.06400415963],
  [413683254, 100.06117577],
  [413683255, 100.094151053069],
  [413683256, 100.019793122907],
  [413683257, 100.020245409076],
  [413683258, 100.00045697003],
  [413683259, 100.011033630617],
  [413683260, 100.075135188935],
  [413683261, 100.077790966401],
  [413683262, 100.009031331436],
  [413683263, 100.095775169877],
  [413683264, 100.077837666627],
  [413683265, 100.035570280889],
  [413683266, 100.025555544333],
  [413683267, 100.012105294621],
  [413683268, 100.053511793279],
  [413683269, 100.064542398234],
  [413683270, 100.046954140335],
  [413683271, 100.044529916724],
  [413683272, 100.040118633638],
  [413683273, 100.072918976849],
  [413683274, 100.074177655077],
  [413683275, 100.061224391101],
  [413683276, 100.080933165191],
  [413683277, 100.089664384536],
  [413683278, 100.044888349238],
  [413683279, 100.032220822243],
  [413683280, 100.088826717159],
  [413683281, 100.028784820279],
  [413683282, 100.013933573517],
  [413683283, 100.047222336589],
  [413683284, 100.023995587039],
  [413683285, 100.031356348448],
  [413683286, 100.002257283607],
  [413683287, 100.054493910431],
  [413683288, 100.068734376899],
  [413683289, 100.098448474003],
  [413683290, 100.054364703972],
  [413683291, 100.033244995575],
  [413683292, 100.055725897912],
  [413683293, 100.051563708743],
  [413683294, 100.051816360564],
  [413683295, 100.043003245612],
  [413683296, 100.023974292049],
  [413683297, 100.096235261339],
  [413683298, 100.080270808679],
  [413683299, 100.086263145773],
  [413683300, 100.041385720611],
);


subtest "startup" => sub {
  my $build_up_count = 10;
  my $f = filter({build_up_count => $build_up_count});
  for my $idx (0 .. $build_up_count - 1) {
    ok($f->($base_time + $idx, rand() * 1000), "input data $idx passes as it is build_time");
  }
};

subtest "constant stream" => sub {
  my $f = filter();
  for my $idx (0 .. 100) {
    ok($f->(1 + $idx / 10, 1), "input data $idx passes");
  }
};

subtest "large disturbance" => sub {
  my $floor = 6;
  my $build_up_count = 10;
  my $f = filter({floor => $floor});
  my $delta = 0.1;

  subtest "tiny disturbance" => sub {
    for my $idx (0 .. @data_samples - 1) {
      my ($epoch, $value) = @{ $data_samples[$idx] };
      ok($f->($epoch, $value), "input data ($epoch // $value ) $idx passes");
    }
  };

  my $last_sample = $data_samples[-1];
  ok !$f->($last_sample->[0] + 0.1, $last_sample->[1] * 100), "large spot disturbance shall not pass";
};

done_testing;
