# Generated by default/object.tt
package Paws::ImageBuilder::ContainerDistributionConfiguration;
  use Moose;
  has ContainerTags => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'containerTags', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has TargetRepository => (is => 'ro', isa => 'Paws::ImageBuilder::TargetContainerRepository', request_name => 'targetRepository', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ImageBuilder::ContainerDistributionConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ImageBuilder::ContainerDistributionConfiguration object:

  $service_obj->Method(Att1 => { ContainerTags => $value, ..., TargetRepository => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ImageBuilder::ContainerDistributionConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->ContainerTags

=head1 DESCRIPTION

Container distribution settings for encryption, licensing, and sharing
in a specific Region.

=head1 ATTRIBUTES


=head2 ContainerTags => ArrayRef[Str|Undef]

Tags that are attached to the container distribution configuration.


=head2 Description => Str

The description of the container distribution configuration.


=head2 B<REQUIRED> TargetRepository => L<Paws::ImageBuilder::TargetContainerRepository>

The destination repository for the container distribution
configuration.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ImageBuilder>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

