BEGIN {
  my $rc;
  $rc = eval {
    require PDF::Builder;
    1;
  };
  if (!defined $rc) { $rc = 0; }
  unless($rc) {
    print qq{1..0 # SKIP these tests; PDF::Builder is not installed\n};
    exit;
  }
}

use Test::More tests => 5;

use PDF::Builder;
use PDF::TextBlock;

ok(my $pdf = PDF::Builder->new( -file => "11-demo.pdf" ),   "PDF::Builder->new()");
ok(my $tb  = PDF::TextBlock->new({
   pdf   => $pdf,
}),                                                   "new()");
ok(my ($endw, $ypos) = $tb->apply(),                  "apply()");

$tb->y($ypos);
$tb->text("Generated by t/11-demo.t");
$tb->fonts->{default}->fillcolor('darkblue');
ok(() = $tb->apply(),                                 "apply()");


$pdf->save;    # Doesn't return true, even when it succeeds. -sigh-
$pdf->end;     # Doesn't return true, even when it succeeds. -sigh-
ok(-r "11-demo.pdf",                                  "11-demo.pdf created");

diag( "Testing PDF::TextBlock $PDF::TextBlock::VERSION, Perl $], $^X" );
