/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.googlecode.mp4parser.authoring.Edit;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.SampleImpl;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.GroupEntry;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SilenceTrackImpl
implements Track {
    Track source;
    List<Sample> samples = new LinkedList<Sample>();
    long[] decodingTimes;
    String name;

    public SilenceTrackImpl(Track ofType, long ms) {
        this.source = ofType;
        this.name = ms + "ms silence";
        if ("mp4a".equals(ofType.getSampleDescriptionBox().getSampleEntry().getType())) {
            int numFrames = CastUtils.l2i(this.getTrackMetaData().getTimescale() * ms / 1000L / 1024L);
            this.decodingTimes = new long[numFrames];
            Arrays.fill(this.decodingTimes, this.getTrackMetaData().getTimescale() * ms / (long)numFrames / 1000L);
            while (numFrames-- > 0) {
                this.samples.add(new SampleImpl((ByteBuffer)ByteBuffer.wrap(new byte[]{33, 16, 4, 96, -116, 28}).rewind()));
            }
        } else {
            throw new RuntimeException("Tracks of type " + ofType.getClass().getSimpleName() + " are not supported");
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.source.getSampleDescriptionBox();
    }

    @Override
    public long[] getSampleDurations() {
        return this.decodingTimes;
    }

    @Override
    public long getDuration() {
        long duration = 0L;
        long[] lArray = this.decodingTimes;
        int n = this.decodingTimes.length;
        int n2 = 0;
        while (n2 < n) {
            long delta = lArray[n2];
            duration += delta;
            ++n2;
        }
        return duration;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.source.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.source.getHandler();
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Edit> getEdits() {
        return null;
    }

    @Override
    public Map<GroupEntry, long[]> getSampleGroups() {
        return this.source.getSampleGroups();
    }
}

