package Test::WWW::Mechanize::LibXML;
$Test::WWW::Mechanize::LibXML::VERSION = '0.0.6';
use warnings;
use strict;

use 5.014;


use parent 'Test::WWW::Mechanize';

use HTML::TreeBuilder::LibXML ();

use MRO::Compat;

use Test::More;


sub libxml_tree
{
    my $self = shift;

    if (@_)
    {
        $self->{libxml_tree} = shift;
    }

    return $self->{libxml_tree};
}

sub _update_page
{
    my $self = shift;

    my $ret = $self->maybe::next::method(@_);

    my $tree = HTML::TreeBuilder::LibXML->new;
    $tree->parse( $self->content() );
    $tree->eof();

    $self->libxml_tree($tree);

    return $ret;
}


sub contains_tag
{
    local $Test::Builder::Level = $Test::Builder::Level + 1;

    my $mech     = shift;
    my $tag_spec = shift;
    my $blurb    = shift;

    my $ret = $mech->libxml_tree->look_down(@$tag_spec);

    ok( $ret, $blurb );

    return $ret;
}


sub tree_matches_xpath
{
    local $Test::Builder::Level = $Test::Builder::Level + 1;

    my $mech  = shift;
    my $xpath = shift;
    my $blurb = shift;

    my @nodes = $mech->libxml_tree->findnodes($xpath);

    return ok( scalar(@nodes), $blurb );
}


1;    # End of Test::WWW::Mechanize::LibXML

__END__

=pod

=encoding UTF-8

=head1 NAME

Test::WWW::Mechanize::LibXML - use HTML::TreeBuilder::LibXML for testing
web-sites.

=head1 VERSION

version 0.0.6

=head1 SYNOPSIS

    use Test::WWW::Mechanize::LibXML;

    my $mech = Test::WWW::Mechanize::LibXML->new();

    # TEST
    $mech->get_ok('http://www.shlomifish.org/');

    # TEST
    $mech->tree_matches_xpath('//p', "There are paragraphs in the page.");

=head1 DESCRIPTION

This module inherits from L<Test::WWW::Mechanize>, and allows one to utilize
L<HTML::TreeBuilder::LibXML> to perform XPath and L<HTML::TreeBuilder>
queries on the tree.

=head1 METHODS

=head2 $mech->libxml_tree()

Returns the L<HTML::TreeBuilder::LibXML> tree of the current page.

=head2 my $tag = $mech->contains_tag($tag_spec, $blurb)

See if the tree contains a tag using C< look_down(@$tag_spec) > and
returns it.

=head2 $mech->tree_matches_xpath($xpath, $blurb)

Determines whether the tree matches the XPath expression $xpath and returns
it.

=head1 AUTHOR

Shlomi Fish, C<< <shlomif at insurgentsoftware.com> >>

=head1 ACKNOWLEDGEMENTS

Thanks to Insurgent Software for sponsoring this work.

=head1 TODO

At the moment, there's a very minimal number of methods here. More should
be added as needed.

=head1 COPYRIGHT & LICENSE

Copyright 2010 Shlomi Fish. (C<shlomif@insurgentsoftware.com>,
L<http://www.shlomifish.org/> )

This program is distributed under the MIT (Expat) License:
L<http://www.opensource.org/licenses/mit-license.php>

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

=for :stopwords cpan testmatrix url bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Websites

The following websites have more information about this module, and may be of help to you. As always,
in addition to those websites please use your favorite search engine to discover more resources.

=over 4

=item *

MetaCPAN

A modern, open-source CPAN search engine, useful to view POD in HTML format.

L<https://metacpan.org/release/Test-WWW-Mechanize-LibXML>

=item *

RT: CPAN's Bug Tracker

The RT ( Request Tracker ) website is the default bug/issue tracking system for CPAN.

L<https://rt.cpan.org/Public/Dist/Display.html?Name=Test-WWW-Mechanize-LibXML>

=item *

CPANTS

The CPANTS is a website that analyzes the Kwalitee ( code metrics ) of a distribution.

L<http://cpants.cpanauthors.org/dist/Test-WWW-Mechanize-LibXML>

=item *

CPAN Testers

The CPAN Testers is a network of smoke testers who run automated tests on uploaded CPAN distributions.

L<http://www.cpantesters.org/distro/T/Test-WWW-Mechanize-LibXML>

=item *

CPAN Testers Matrix

The CPAN Testers Matrix is a website that provides a visual overview of the test results for a distribution on various Perls/platforms.

L<http://matrix.cpantesters.org/?dist=Test-WWW-Mechanize-LibXML>

=item *

CPAN Testers Dependencies

The CPAN Testers Dependencies is a website that shows a chart of the test results of all dependencies for a distribution.

L<http://deps.cpantesters.org/?module=Test::WWW::Mechanize::LibXML>

=back

=head2 Bugs / Feature Requests

Please report any bugs or feature requests by email to C<bug-test-www-mechanize-libxml at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/Public/Bug/Report.html?Queue=Test-WWW-Mechanize-LibXML>. You will be automatically notified of any
progress on the request by the system.

=head2 Source Code

The code is open to the world, and available for you to hack on. Please feel free to browse it and play
with it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

L<https://github.com/shlomif/test-www-mechanize-libxml>

  git clone https://github.com/shlomif/perl-Test-WWW-Mechanize-LibXML

=head1 AUTHOR

Shlomi Fish <shlomif@insurgentsoftware.com>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/shlomif/test-www-mechanize-libxml/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Shlomi Fish.

This is free software, licensed under:

  The MIT (X11) License

=cut
