#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util::GMP qw/is_prime/;

my $extra = defined $ENV{RELEASE_TESTING} && $ENV{RELEASE_TESTING};

plan tests => 0 + 6
                + 19
                + 3573
                + 10
                + 29
                + 22
                + 23
                + 16
                + 15
                + 28
                + 32
                + 8
                + 6
                + 10
                + 0;

# Some of these tests were inspired by Math::Primality's tests

ok( is_prime(2),  '2 is prime');
ok(!is_prime(1),  '1 is not prime');
ok(!is_prime(0),  '0 is not prime');
ok(!is_prime(-1), '-1 is not prime');
ok(!is_prime(-2), '-2 is not prime');
ok(!is_prime(20), '20 is not prime');

# powers of 2
foreach my $k (2 .. 20) {
  my $k2 = 2**$k;
  ok(!is_prime($k2), "2**$k=$k2 is not prime");
}

my @small_primes = qw/
2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 71
73 79 83 89 97 101 103 107 109 113 127 131 137 139 149 151 157 163 167 173
179 181 191 193 197 199 211 223 227 229 233 239 241 251 257 263 269 271 277 281
283 293 307 311 313 317 331 337 347 349 353 359 367 373 379 383 389 397 401 409
419 421 431 433 439 443 449 457 461 463 467 479 487 491 499 503 509 521 523 541
547 557 563 569 571 577 587 593 599 601 607 613 617 619 631 641 643 647 653 659
661 673 677 683 691 701 709 719 727 733 739 743 751 757 761 769 773 787 797 809
811 821 823 827 829 839 853 857 859 863 877 881 883 887 907 911 919 929 937 941
947 953 967 971 977 983 991 997 1009 1013 1019 1021 1031 1033 1039 1049 1051 1061 1063 1069
1087 1091 1093 1097 1103 1109 1117 1123 1129 1151 1153 1163 1171 1181 1187 1193 1201 1213 1217 1223
1229 1231 1237 1249 1259 1277 1279 1283 1289 1291 1297 1301 1303 1307 1319 1321 1327 1361 1367 1373
1381 1399 1409 1423 1427 1429 1433 1439 1447 1451 1453 1459 1471 1481 1483 1487 1489 1493 1499 1511
1523 1531 1543 1549 1553 1559 1567 1571 1579 1583 1597 1601 1607 1609 1613 1619 1621 1627 1637 1657
1663 1667 1669 1693 1697 1699 1709 1721 1723 1733 1741 1747 1753 1759 1777 1783 1787 1789 1801 1811
1823 1831 1847 1861 1867 1871 1873 1877 1879 1889 1901 1907 1913 1931 1933 1949 1951 1973 1979 1987
1993 1997 1999 2003 2011 2017 2027 2029 2039 2053 2063 2069 2081 2083 2087 2089 2099 2111 2113 2129
2131 2137 2141 2143 2153 2161 2179 2203 2207 2213 2221 2237 2239 2243 2251 2267 2269 2273 2281 2287
2293 2297 2309 2311 2333 2339 2341 2347 2351 2357 2371 2377 2381 2383 2389 2393 2399 2411 2417 2423
2437 2441 2447 2459 2467 2473 2477 2503 2521 2531 2539 2543 2549 2551 2557 2579 2591 2593 2609 2617
2621 2633 2647 2657 2659 2663 2671 2677 2683 2687 2689 2693 2699 2707 2711 2713 2719 2729 2731 2741
2749 2753 2767 2777 2789 2791 2797 2801 2803 2819 2833 2837 2843 2851 2857 2861 2879 2887 2897 2903
2909 2917 2927 2939 2953 2957 2963 2969 2971 2999 3001 3011 3019 3023 3037 3041 3049 3061 3067 3079
3083 3089 3109 3119 3121 3137 3163 3167 3169 3181 3187 3191 3203 3209 3217 3221 3229 3251 3253 3257
3259 3271 3299 3301 3307 3313 3319 3323 3329 3331 3343 3347 3359 3361 3371 3373 3389 3391 3407 3413
3433 3449 3457 3461 3463 3467 3469 3491 3499 3511 3517 3527 3529 3533 3539 3541 3547 3557 3559 3571
/;
my %small_primes;
map { $small_primes{$_} = 1; } @small_primes;

foreach my $n (0 .. 3572) {
  if (defined $small_primes{$n}) {
    ok(is_prime($n), "$n is prime");
  } else {
    ok(!is_prime($n), "$n is not prime");
  }
}

map { ok(!is_prime($_), "A006945 number $_ is not prime") }
  qw/9 2047 1373653 25326001 3215031751
     2152302898747 3474749660383 341550071728321 341550071728321 3825123056546413051/;

map { ok(!is_prime($_), "Carmichael Number $_ is not prime") }
  qw/561 1105 1729 2465 2821 6601 8911 10585 15841 29341 41041 46657 52633
     62745 63973 75361 101101 340561 488881 852841 1857241 6733693
     9439201 17236801 23382529 34657141 56052361 146843929 216821881/;

map { ok(!is_prime($_), "Pseudoprime (base 2) $_ is not prime" ) }
  qw/341 561 645 1105 1387 1729 1905 2047 2465 2701 2821 3277 4033 4369 4371
     4681 5461 6601 7957 8321 52633 88357/;

map { ok(!is_prime($_), "Pseudoprime (base 3) $_ is not prime" ) }
  qw/121 703 1891 3281 8401 8911 10585 12403 16531 18721 19345 23521 31621
     44287 47197 55969 63139 74593 79003 82513 87913 88573 97567/;

map { ok(!is_prime($_), "Pseudoprime (base 5) $_ is not prime" ) }
  qw/781 1541 5461 5611 7813 13021 14981 15751 24211 25351 29539 38081
     40501 44801 53971 79381/;

map { ok(is_prime($_), "Primegap start $_ is prime" ) }
  qw/2 3 7 23 89 113 523 887 1129 1327 9551 15683 19609 31397 155921/;

map { ok(is_prime($_), "Primegap end $_ is prime" ) }
  qw/5 11 29 97 127 541 907 1151 1361 9587 15727 19661 31469 156007 360749
     370373 492227 1349651 1357333 2010881 4652507 17051887 20831533 47326913
     122164969 189695893 191913031 10726905041/;

map { ok(is_prime($_), "Primegap end $_ is prime" ) }
  qw/387096383 436273291 1294268779 1453168433 2300942869 3842611109
     4302407713 20678048681 22367085353
     25056082543 42652618807 127976334671 182226896239 241160624143
     297501075799 303371455241 304599508537 416608695821 461690510011
     614487453523 738832927927 1346294310749 1408695493609 1968188556461
     2614941710599 7177162611713 13829048559701 19581334192423
     42842283925351 90874329411493 171231342420521 1425172824437699411/;

map { ok(is_prime($_), "Primegap start $_ is prime" ) }
  qw/41437872381314257606025664648551531 2533428381785258181145396408525147
     6429801387755251608076552195160813 41553317381222258299076384479889759
     36315406071322208317982870602883 45578379712061211117046756353187
     853188381785258606010648985968457 888753381785258606882214366477061/;

map { ok(is_prime($_), "Large prime $_ is prime" ) }
  qw/225024267640198977569930286413453544441731198242501
     117012619172903468336363755054149226979817746816041
     531137992816767098689588206552468627329593117727031923199444138200403559860852242739162502265229285668889329486246501015346579337652707239409519978766587351943831270835393219031728127
     92751329613360357106269703807871171087102857318174669180345062763478315192734600581256686043065309145579066294614789483004809764977045757613701500430172705662998376708484136826337990209855359024352422688815970711638591317382567474931186571722543217265405033315880950490013269952667650366965082529384527374177
     32260744804243979022151766262161234411163230832614876909266661009538736040353215637132894501612353010543647977249384696464608093622417037943487940297713136625578440884358987868505411720686648801150726329314235915696991593215969719047680808482063865275910410329176506289872973203004139815308900515515244012185782792865548320042281725631557473818091156913398618606687353487817756951894689296125125745219508443864021389470338722761499570221166792212754530607135317650463501248358538246234526221292291399209816873396728066128587613467291339613990745570031925686037674992827058364602015693306309221496407276025345897341847
    741396953013654360447130328344036195463451575964208809937212804294129714670068945580433523222395982402982697545970774900776520388371921559613345658117858514521005297959953114279118002815246386498175953512848112483829848122269294444605330839657412152438182209874755797291767504531960060238286549305381539583199152421722832641143066110744833138611455286547147404482909367418917279008726128416147000372123061195691620902127739725422428617685907314016736926212798020427887587562043320485749196280067057894293080208114019557078624547720775548197602227651474547221582994513675272163167738690346545549988775205966423807402030104516784101084806845639397870429182441506430010222493085299118475419254862008744168191879396758301572743283703529570334803330960201229624052255881219905504918044357793149162118185478553170626317902665884547746435111999694067410243494584529487741658481642249023103753134680734412840328449909896847175077758262986499427135151069709448521414215035574272868281224727572369419529536625125298888387473824456936636521457187215362102409447089422614360505828034680296548026192715652255266408626555770777003931789812374333546088379306076791601248774333377106632994883876629562024348840502578094204183502272143692446875343057
    /;

map { ok(!is_prime($_), "Large composite $_ is not prime" ) }
  qw/777777777777777777777777
     877777777777777777777777
     87777777777777777777777795475
     890745785790123461234805903467891234681234
     318665857834031151167461
     3317044064679887385961981
     6003094289670105800312596501
     59276361075595573263446330101
     564132928021909221014087501701
     1543267864443420616877677640751301
    /;
