package JSON::Karabiner::Rule ;
$JSON::Karabiner::Rule::VERSION = '0.003';
use strict;
use warnings;
use JSON::Karabiner::Manipulator ;
use Carp;

sub new {
  my $class = shift;
  my $desc = shift;
  croak 'JSON::Karabiner constructor requires a desc.' if !$desc;
  my $self = {
    description => $desc,
    manipulators => []
  };
  bless $self, $class;
  return $self;
}

sub add_manipulator {
  my $s = shift;

  my $manip  = JSON::Karabiner::Manipulator->new($s->{manipulators});
  push @{$s->{manipulators}}, $manip;
  return $manip;
}

sub TO_JSON { return { %{ shift() } }; }


# ABSTRACT: turns baubles into trinkets

1;

__END__

=pod

=head1 NAME

JSON::Karabiner::Rule - turns baubles into trinkets

=head1 VERSION

version 0.003

=head1 DESCRIPTION

Please see the L<JSON::Karabiner> for more thorough documentation of these module.
Methods are listed below for reference purposes only.

=head3 add_manipulator()

=head1 AUTHOR

Steve Dondley <s@dondley.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by Steve Dondley.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
