/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.NodePattern;
import edu.stanford.nlp.ling.tokensregex.types.Expression;
import edu.stanford.nlp.ling.tokensregex.types.Expressions;
import edu.stanford.nlp.ling.tokensregex.types.Value;
import edu.stanford.nlp.util.CoreMap;

public class CoreMapExpressionNodePattern
extends NodePattern<CoreMap> {
    Env env;
    Expression expression;

    public CoreMapExpressionNodePattern() {
    }

    public CoreMapExpressionNodePattern(Env env, Expression expression) {
        this.env = env;
        this.expression = expression;
    }

    public static CoreMapExpressionNodePattern valueOf(Expression expression) {
        return CoreMapExpressionNodePattern.valueOf(null, expression);
    }

    public static CoreMapExpressionNodePattern valueOf(Env env, Expression expression) {
        CoreMapExpressionNodePattern p = new CoreMapExpressionNodePattern(env, expression);
        return p;
    }

    @Override
    public boolean match(CoreMap token) {
        Value v = this.expression.evaluate(this.env, token);
        Boolean matched = Expressions.convertValueToBoolean(v, false);
        return matched != null ? matched : false;
    }

    public String toString() {
        return this.expression.toString();
    }
}

