/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.BasicDocument;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.process.PTBTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;

public class DocumentReader<L> {
    protected BufferedReader in;
    protected TokenizerFactory<? extends HasWord> tokenizerFactory;
    protected boolean keepOriginalText;

    public DocumentReader() {
        this(null);
    }

    public DocumentReader(Reader in) {
        this(in, PTBTokenizer.PTBTokenizerFactory.newTokenizerFactory(), true);
    }

    public DocumentReader(Reader in, TokenizerFactory<? extends HasWord> tokenizerFactory, boolean keepOriginalText) {
        if (in != null) {
            this.setReader(in);
        }
        this.setTokenizerFactory(tokenizerFactory);
        this.keepOriginalText = keepOriginalText;
    }

    public Reader getReader() {
        return this.in;
    }

    public void setReader(Reader in) {
        this.in = DocumentReader.getBufferedReader(in);
    }

    public TokenizerFactory<? extends HasWord> getTokenizerFactory() {
        return this.tokenizerFactory;
    }

    public void setTokenizerFactory(TokenizerFactory<? extends HasWord> tokenizerFactory) {
        this.tokenizerFactory = tokenizerFactory;
    }

    public boolean getKeepOriginalText() {
        return this.keepOriginalText;
    }

    public void setKeepOriginalText(boolean keepOriginalText) {
        this.keepOriginalText = keepOriginalText;
    }

    public BasicDocument<L> readDocument() throws IOException {
        String text = this.readNextDocumentText();
        if (text == null) {
            return null;
        }
        return this.parseDocumentText(text);
    }

    protected String readNextDocumentText() throws IOException {
        return DocumentReader.readText(this.in);
    }

    protected BasicDocument<L> parseDocumentText(String text) {
        new BasicDocument();
        return BasicDocument.init(text, this.keepOriginalText);
    }

    public static BufferedReader getBufferedReader(Reader in) {
        if (in == null) {
            return null;
        }
        if (!(in instanceof BufferedReader)) {
            in = new BufferedReader(in);
        }
        return (BufferedReader)in;
    }

    public static String readText(Reader in) throws IOException {
        int c;
        if (in == null) {
            return null;
        }
        BufferedReader br = DocumentReader.getBufferedReader(in);
        StringBuilder sb = new StringBuilder(16000);
        while ((c = br.read()) >= 0) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static Reader getReader(String text) {
        return new StringReader(text);
    }

    public static Reader getReader(File file) throws FileNotFoundException {
        return new FileReader(file);
    }

    public static Reader getReader(URL url) throws IOException {
        return DocumentReader.getReader(url.openStream());
    }

    public static Reader getReader(InputStream in) {
        return new InputStreamReader(in);
    }
}

