# Generated by default/object.tt
package Paws::SageMaker::FeatureDefinition;
  use Moose;
  has FeatureName => (is => 'ro', isa => 'Str');
  has FeatureType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::FeatureDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::FeatureDefinition object:

  $service_obj->Method(Att1 => { FeatureName => $value, ..., FeatureType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::FeatureDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->FeatureName

=head1 DESCRIPTION

A list of features. You must include C<FeatureName> and C<FeatureType>.
Valid feature C<FeatureType>s are C<Integral>, C<Fractional> and
C<String>.

=head1 ATTRIBUTES


=head2 FeatureName => Str

The name of a feature. The type must be a string. C<FeatureName> cannot
be any of the following: C<is_deleted>, C<write_time>,
C<api_invocation_time>.


=head2 FeatureType => Str

The value type of a feature. Valid values are Integral, Fractional, or
String.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

