# Generated by default/object.tt
package Paws::CodeGuruReviewer::RepositoryAnalysis;
  use Moose;
  has RepositoryHead => (is => 'ro', isa => 'Paws::CodeGuruReviewer::RepositoryHeadSourceCodeType');
  has SourceCodeType => (is => 'ro', isa => 'Paws::CodeGuruReviewer::SourceCodeType');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruReviewer::RepositoryAnalysis

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruReviewer::RepositoryAnalysis object:

  $service_obj->Method(Att1 => { RepositoryHead => $value, ..., SourceCodeType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruReviewer::RepositoryAnalysis object:

  $result = $service_obj->Method(...);
  $result->Att1->RepositoryHead

=head1 DESCRIPTION

A code review type that analyzes all code under a specified branch in
an associated repository. The associated repository is specified using
its ARN when you call C<CreateCodeReview>
(https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview).

=head1 ATTRIBUTES


=head2 RepositoryHead => L<Paws::CodeGuruReviewer::RepositoryHeadSourceCodeType>

A C<SourceCodeType>
(https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType)
that specifies the tip of a branch in an associated repository.


=head2 SourceCodeType => L<Paws::CodeGuruReviewer::SourceCodeType>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruReviewer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

