# Generated by default/object.tt
package Paws::Health::OrganizationEventDetailsErrorItem;
  use Moose;
  has AwsAccountId => (is => 'ro', isa => 'Str', request_name => 'awsAccountId', traits => ['NameInRequest']);
  has ErrorMessage => (is => 'ro', isa => 'Str', request_name => 'errorMessage', traits => ['NameInRequest']);
  has ErrorName => (is => 'ro', isa => 'Str', request_name => 'errorName', traits => ['NameInRequest']);
  has EventArn => (is => 'ro', isa => 'Str', request_name => 'eventArn', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Health::OrganizationEventDetailsErrorItem

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Health::OrganizationEventDetailsErrorItem object:

  $service_obj->Method(Att1 => { AwsAccountId => $value, ..., EventArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Health::OrganizationEventDetailsErrorItem object:

  $result = $service_obj->Method(...);
  $result->Att1->AwsAccountId

=head1 DESCRIPTION

Error information returned when a DescribeEventDetailsForOrganization
(https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html)
operation can't find a specified event.

=head1 ATTRIBUTES


=head2 AwsAccountId => Str

Error information returned when a DescribeEventDetailsForOrganization
(https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html)
operation can't find a specified event.


=head2 ErrorMessage => Str

A message that describes the error.

If you call the C<DescribeEventDetailsForOrganization> operation and
receive one of the following errors, follow the recommendations in the
message:

=over

=item *

We couldn't find a public event that matches your request. To find an
event that is account specific, you must enter an AWS account ID in the
request.

=item *

We couldn't find an account specific event for the specified AWS
account. To find an event that is public, you must enter a null value
for the AWS account ID in the request.

=item *

Your AWS account doesn't include the AWS Support plan required to use
the AWS Health API. You must have either a Business or Enterprise
Support plan.

=back



=head2 ErrorName => Str

The name of the error.


=head2 EventArn => Str

The unique identifier for the event. The event ARN has the
C<arn:aws:health:I<event-region>::event/I<SERVICE>/I<EVENT_TYPE_CODE>/I<EVENT_TYPE_PLUS_ID>
> format.

For example, an event ARN might look like the following:

C<arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Health>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

