package Google::Ads::AdWords::v201402::Detail;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/mcm/v201402' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %triggerTime_of :ATTR(:get<triggerTime>);

__PACKAGE__->_factory(
    [ qw(        triggerTime

    ) ],
    {
        'triggerTime' => \%triggerTime_of,
    },
    {
        'triggerTime' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'triggerTime' => 'triggerTime',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201402::Detail

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Detail from the namespace https://adwords.google.com/api/adwords/mcm/v201402.

Detail refers to a single event or condition that triggered its owning {@link Alert}. Multiple details can cause the same {@code Alert} to occur. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * triggerTime




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

