######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT -4
package Geo::Location::TimeZone::Q;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude -67.5 to -52.5
	"-4" => {
		# Grid -4:-6 ; 3 records
		"-6" => {
			"def_z" => "Antartica/South_Pole",
			"303" => {
				"z" => "Etc/GMT-3",
				"c" => "ESRI",
				"s" => "19,1",
				"p" => [[-54.8008346557617,-82.5],[-52.5,-82.5],[-52.5,-90],[-52.5029716491699,-90],[-52.5032234191895,-82.5388793945312],[-52.5032247265421,-82.5],[-53.4058380126953,-82.5],[-54.8008346557617,-82.5],],
			},
			"458" => {
				"z" => "Etc/GMT-5",
				"c" => "ESRI",
				"s" => "32,1",
				"p" => [[-63.3777770996094,-82.5],[-67.4927673339844,-82.5],[-67.4927673339844,-90],[-67.5,-90],[-67.5,-82.5],[-66.4855499267578,-82.5],[-63.3777770996094,-82.5],],
			},
		},
		# Grid -4:-5 ; 2 records
		"-5" => {
			"def_z" => "Etc/GMT-5",
			"304" => {
				"z" => "Etc/GMT-3",
				"c" => "ESRI",
				"s" => "19,1",
				"p" => [[-54.8008346557617,-67.5],[-52.5,-67.5],[-52.5,-82.5],[-52.5032247265421,-82.5],[-52.5036773681641,-69.0388793945312],[-52.5037187726151,-67.5],[-53.4058380126953,-67.5],[-54.8008346557617,-67.5],],
			},
		},
		# Grid -4:-4 ; 3 records
		"-4" => {
			"305" => {
				"z" => "Etc/GMT-3",
				"c" => "ESRI",
				"s" => "19,1",
				"p" => [[-54.8008346557617,-52.5],[-52.5,-52.5],[-52.5,-67.5],[-52.5037187726151,-67.5],[-52.5041223563969,-52.5],[-67.4992878437465,-52.5],[-67.4955444335938,-53.9528770446777],[-66.9241790771484,-54.2191696166992],[-66.70361328125,-54.2891693115234],[-66.5466766357422,-54.4138946533203],[-66.2716674804688,-54.5280609130859],[-65.8275146484375,-54.6558380126953],[-65.6736145019531,-54.6730575561523],[-65.2236175537109,-54.6336135864258],[-64.5526580810547,-54.7149963378906],[-64.4539031982422,-54.7583389282227],[-64.4127807617188,-54.7366714477539],[-64.3811187744141,-54.7886123657227],[-64.3580627441406,-54.7063903808594],[-64.1783447265625,-54.7508392333984],[-64.1683349609375,-54.7141723632812],[-64.0641784667969,-54.75],[-63.9200057983398,-54.7141723632812],[-63.8136138916016,-54.7313919067383],[-63.9686126708984,-54.8180618286133],[-63.9727783203125,-54.7597274780273],[-64.2538909912109,-54.8422241210938],[-64.2530670166016,-54.7797241210938],[-64.3094482421875,-54.7777786254883],[-64.4186248779297,-54.8386154174805],[-64.4961242675781,-54.8269500732422],[-64.6097259521484,-54.9000015258789],[-64.6783447265625,-54.9072265625],[-65.3766784667969,-54.9305572509766],[-65.4713897705078,-54.8836135864258],[-65.4900054931641,-54.9347229003906],[-65.5988922119141,-54.9305572509766],[-65.6575012207031,-54.9722290039062],[-65.7058410644531,-54.9661178588867],[-65.73779296875,-54.902229309082],[-65.9552917480469,-54.8961181640625],[-66.0133361816406,-54.9561157226562],[-66.3719482421875,-54.9850006103516],[-66.4580688476562,-55.0516738891602],[-66.6494445800781,-55.0258407592773],[-66.7964019775391,-54.945556640625],[-67.0113372802734,-54.9086151123047],[-67.5,-54.8896273604573],[-67.5,-52.5],[-53.4058380126953,-52.5],[-54.8008346557617,-52.5],],
			},
			"460" => {
				"z" => "Etc/GMT-5",
				"c" => "ESRI",
				"s" => "32,1",
				"p" => [[-63.3777770996094,-52.5],[-67.5,-52.5],[-67.5,-55.9579101255378],[-67.4927673339844,-55.9593162536621],[-67.4927673339844,-67.5],[-67.5,-67.5],[-67.5,-52.5],[-66.4855499267578,-52.5],[-63.3777770996094,-52.5],],
			},
			"479" => {
				"z" => "Antartica/Palmer",
				"c" => "ESRI",
				"s" => "33,2",
				"p" => [[-61.1163940429688,-52.5],[-67.5,-52.5],[-67.5,-54.8896273604573],[-67.0113372802734,-54.9086151123047],[-66.7964019775391,-54.945556640625],[-66.6494445800781,-55.0258407592773],[-66.4580688476562,-55.0516738891602],[-66.3719482421875,-54.9850006103516],[-66.0133361816406,-54.9561157226562],[-65.9552917480469,-54.8961181640625],[-65.73779296875,-54.902229309082],[-65.7058410644531,-54.9661178588867],[-65.6575012207031,-54.9722290039062],[-65.5988922119141,-54.9305572509766],[-65.4900054931641,-54.9347229003906],[-65.4713897705078,-54.8836135864258],[-65.3766784667969,-54.9305572509766],[-64.6783447265625,-54.9072265625],[-64.6097259521484,-54.9000015258789],[-64.4961242675781,-54.8269500732422],[-64.4186248779297,-54.8386154174805],[-64.3094482421875,-54.7777786254883],[-64.2530670166016,-54.7797241210938],[-64.2538909912109,-54.8422241210938],[-63.9727783203125,-54.7597274780273],[-63.9686126708984,-54.8180618286133],[-63.8136138916016,-54.7313919067383],[-63.9200057983398,-54.7141723632812],[-64.0641784667969,-54.75],[-64.1683349609375,-54.7141723632812],[-64.1783447265625,-54.7508392333984],[-64.3580627441406,-54.7063903808594],[-64.3811187744141,-54.7886123657227],[-64.4127807617188,-54.7366714477539],[-64.4539031982422,-54.7583389282227],[-64.5526580810547,-54.7149963378906],[-65.2236175537109,-54.6336135864258],[-65.6736145019531,-54.6730575561523],[-65.8275146484375,-54.6558380126953],[-66.2716674804688,-54.5280609130859],[-66.5466766357422,-54.4138946533203],[-66.70361328125,-54.2891693115234],[-66.9241790771484,-54.2191696166992],[-67.4955444335938,-53.9528770446777],[-67.4992878437465,-52.5],[-52.5041223563969,-52.5],[-52.5037187726151,-67.5],[-67.4927673339844,-67.5],[-67.4927673339844,-55.9593162536621],[-67.5,-55.9579101255378],[-67.5,-52.5],[-57.553337097168,-52.5],[-61.1163940429688,-52.5],],
			},
		},
		# Grid -4:-3 ; 2 records
		"-3" => {
			"306" => {
				"z" => "Etc/GMT-3",
				"c" => "ESRI",
				"s" => "19,1",
				"p" => [[-54.8008346557617,-37.5],[-52.5,-37.5],[-52.5,-52.5],[-52.5041223563969,-52.5],[-52.5045259401787,-37.5],[-57.1274160536744,-37.5],[-57.4805603027344,-37.8258361816406],[-57.5411148071289,-37.9819488525391],[-57.5330581665039,-38.0861129760742],[-57.6347274780273,-38.1800003051758],[-57.8458404541016,-38.2991714477539],[-58.3122253417969,-38.4897232055664],[-58.7227783203125,-38.5805587768555],[-59.0380630493164,-38.6925048828125],[-59.6100006103516,-38.7797241210938],[-59.7897262573242,-38.8369445800781],[-60.8600006103516,-38.9763946533203],[-61.162223815918,-38.998893737793],[-61.3836135864258,-38.9797286987305],[-61.5625457763672,-39.0122413635254],[-61.858814239502,-39.2417831420898],[-62.0500259399414,-39.4887657165527],[-62.1163940429688,-39.8394470214844],[-62.1891708374023,-39.8600006103516],[-62.307502746582,-39.8186111450195],[-62.2861175537109,-39.8547286987305],[-62.3200073242188,-39.8683395385742],[-62.3641738891602,-40.0552825927734],[-62.352783203125,-40.1816711425781],[-62.4894485473633,-40.299446105957],[-62.4208374023438,-40.4594497680664],[-62.3313903808594,-40.4983367919922],[-62.2911148071289,-40.5658340454102],[-62.2600021362305,-40.5600051879883],[-62.2613906860352,-40.6333389282227],[-62.3480606079102,-40.6072235107422],[-62.3266677856445,-40.678337097168],[-62.1838912963867,-40.6297225952148],[-62.2297286987305,-40.6636123657227],[-62.3211135864258,-40.8672256469727],[-62.7233352661133,-41.0461120605469],[-62.8013916015625,-41.0433349609375],[-63.0333404541016,-41.1483383178711],[-63.1419448852539,-41.1605606079102],[-63.807502746582,-41.1591720581055],[-63.9600067138672,-41.0644454956055],[-64.0583343505859,-41.0450057983398],[-64.0533447265625,-40.9991683959961],[-64.1422271728516,-41.0219497680664],[-64.4125061035156,-40.9094467163086],[-64.6911163330078,-40.8388900756836],[-64.8852844238281,-40.8380584716797],[-64.9116668701172,-40.8202819824219],[-64.8961181640625,-40.7986145019531],[-64.7491760253906,-40.8027801513672],[-64.751953125,-40.7769470214844],[-64.7975006103516,-40.7722244262695],[-64.7752838134766,-40.732780456543],[-64.9813995361328,-40.7219467163086],[-64.9263916015625,-40.7286148071289],[-64.9380645751953,-40.7563934326172],[-64.9061126708984,-40.7686157226562],[-65.0125122070312,-40.7719497680664],[-65.1258392333984,-40.8405609130859],[-65.1797332763672,-40.9966735839844],[-65.0711212158203,-41.4333343505859],[-64.9911193847656,-41.5108337402344],[-65.0291748046875,-41.6755599975586],[-64.9908447265625,-41.7786178588867],[-65.0744476318359,-41.9316711425781],[-65.0622253417969,-42.0100021362305],[-64.9941711425781,-42.1122283935547],[-64.8713989257812,-42.1919479370117],[-64.4625091552734,-42.2636184692383],[-64.6069488525391,-42.4188919067383],[-64.4519500732422,-42.4458389282227],[-64.3041687011719,-42.415283203125],[-64.118896484375,-42.4344482421875],[-64.0452880859375,-42.3725051879883],[-64.0630645751953,-42.2786178588867],[-64.3344573974609,-42.2366714477539],[-64.1991729736328,-42.2241668701172],[-63.8719482421875,-42.1025009155273],[-63.7469482421875,-42.0905609130859],[-63.5908355712891,-42.3169479370117],[-63.5780563354492,-42.6061172485352],[-63.6333389282227,-42.7127838134766],[-63.6258392333984,-42.7619476318359],[-63.6930618286133,-42.8216705322266],[-64.0869445800781,-42.8902816772461],[-64.2491760253906,-42.7761154174805],[-64.1961212158203,-42.6388931274414],[-64.3980560302734,-42.5158386230469],[-64.6219482421875,-42.5200042724609],[-64.8208465576172,-42.6286163330078],[-64.9605560302734,-42.666389465332],[-65.01806640625,-42.7394485473633],[-64.9927825927734,-42.7936172485352],[-64.8086242675781,-42.8402786254883],[-64.5939025878906,-42.9411163330078],[-64.5038909912109,-42.9380569458008],[-64.4102783203125,-42.9780578613281],[-64.3155670166016,-42.9494476318359],[-64.2950134277344,-42.9919509887695],[-64.4916687011719,-43.0844497680664],[-64.80029296875,-43.1611175537109],[-65.0280609130859,-43.3044509887695],[-65.0372314453125,-43.394172668457],[-65.3302917480469,-43.6677780151367],[-65.3200073242188,-43.819450378418],[-65.2583465576172,-43.9697265625],[-65.2102813720703,-43.9552841186523],[-65.2244567871094,-44.1075057983398],[-65.2969512939453,-44.1322250366211],[-65.3125,-44.1869506835938],[-65.2280578613281,-44.336669921875],[-65.3422241210938,-44.4386138916016],[-65.2766723632812,-44.4802780151367],[-65.3594512939453,-44.4830627441406],[-65.3875122070312,-44.5216674804688],[-65.3613891601562,-44.5441741943359],[-65.4405670166016,-44.5380630493164],[-65.5994567871094,-44.6180572509766],[-65.7191772460938,-44.7761154174805],[-65.7108459472656,-44.8336181640625],[-65.5305633544922,-44.8950042724609],[-65.5847320556641,-44.924446105957],[-65.604736328125,-45.0163955688477],[-65.6855621337891,-45.0430603027344],[-65.8513946533203,-44.98583984375],[-65.8752899169922,-45.0194473266602],[-65.9491729736328,-45.0222244262695],[-66.0152893066406,-44.9738922119141],[-66.1947326660156,-44.9591674804688],[-66.2850036621094,-45.0316696166992],[-66.5219573974609,-45.086669921875],[-66.5347290039062,-45.115837097168],[-66.4597320556641,-45.1436157226562],[-66.588623046875,-45.1386184692383],[-66.5191802978516,-45.1788940429688],[-66.5352783203125,-45.2044448852539],[-66.8466796875,-45.2102813720703],[-66.9494476318359,-45.2555618286133],[-67.1836242675781,-45.5286178588867],[-67.3161163330078,-45.6150054931641],[-67.3416748046875,-45.7788925170898],[-67.4222259521484,-45.8219451904297],[-67.5,-45.9075039629768],[-67.5,-46.455863280903],[-67.3380584716797,-46.6252822875977],[-67.1244506835938,-46.7263946533203],[-67.0547332763672,-46.8100051879883],[-66.7166748046875,-47.0400009155273],[-66.2091674804688,-47.0936126708984],[-65.9933471679688,-47.0666732788086],[-65.9000091552734,-47.0986175537109],[-65.7722320556641,-47.1983337402344],[-65.7322235107422,-47.3441696166992],[-65.7569580078125,-47.5419464111328],[-65.8758392333984,-47.7622222900391],[-66.0225067138672,-47.7608337402344],[-66.1208343505859,-47.8197250366211],[-66.3216705322266,-47.8730621337891],[-66.3886260986328,-47.8625030517578],[-66.3241729736328,-47.8827819824219],[-65.9733428955078,-47.7838897705078],[-65.9119567871094,-47.8041687011719],[-65.8700103759766,-47.902229309082],[-65.7872314453125,-47.9355621337891],[-65.7958374023438,-47.9702835083008],[-65.9713897705078,-47.9611129760742],[-65.8977813720703,-48.099723815918],[-66.0794525146484,-48.1044464111328],[-66.1414031982422,-48.1847229003906],[-66.3355560302734,-48.2836151123047],[-66.3275146484375,-48.3455581665039],[-66.4436187744141,-48.3472290039062],[-66.4680633544922,-48.399169921875],[-66.6675109863281,-48.4416732788086],[-66.8266754150391,-48.5711135864258],[-67.0827789306641,-48.6388931274414],[-67.2397308349609,-48.8227844238281],[-67.399169921875,-48.8905563354492],[-67.5,-48.9770123143866],[-67.5,-52.2236008263316],[-67.4992878437465,-52.5],[-67.5,-52.5],[-67.5,-37.5],[-53.4058380126953,-37.5],[-54.8008346557617,-37.5],],
			},
			"480" => {
				"z" => "Atlantic/Stanley",
				"c" => "ESRI",
				"s" => "33,2",
				"p" => [[-61.1163940429688,-37.5],[-67.5,-37.5],[-67.5,-52.5],[-67.4992878437465,-52.5],[-67.5,-52.2236008263316],[-67.5,-48.9770123143866],[-67.399169921875,-48.8905563354492],[-67.2397308349609,-48.8227844238281],[-67.0827789306641,-48.6388931274414],[-66.8266754150391,-48.5711135864258],[-66.6675109863281,-48.4416732788086],[-66.4680633544922,-48.399169921875],[-66.4436187744141,-48.3472290039062],[-66.3275146484375,-48.3455581665039],[-66.3355560302734,-48.2836151123047],[-66.1414031982422,-48.1847229003906],[-66.0794525146484,-48.1044464111328],[-65.8977813720703,-48.099723815918],[-65.9713897705078,-47.9611129760742],[-65.7958374023438,-47.9702835083008],[-65.7872314453125,-47.9355621337891],[-65.8700103759766,-47.902229309082],[-65.9119567871094,-47.8041687011719],[-65.9733428955078,-47.7838897705078],[-66.3241729736328,-47.8827819824219],[-66.3886260986328,-47.8625030517578],[-66.3216705322266,-47.8730621337891],[-66.1208343505859,-47.8197250366211],[-66.0225067138672,-47.7608337402344],[-65.8758392333984,-47.7622222900391],[-65.7569580078125,-47.5419464111328],[-65.7322235107422,-47.3441696166992],[-65.7722320556641,-47.1983337402344],[-65.9000091552734,-47.0986175537109],[-65.9933471679688,-47.0666732788086],[-66.2091674804688,-47.0936126708984],[-66.7166748046875,-47.0400009155273],[-67.0547332763672,-46.8100051879883],[-67.1244506835938,-46.7263946533203],[-67.3380584716797,-46.6252822875977],[-67.5,-46.455863280903],[-67.5,-45.9075039629768],[-67.4222259521484,-45.8219451904297],[-67.3416748046875,-45.7788925170898],[-67.3161163330078,-45.6150054931641],[-67.1836242675781,-45.5286178588867],[-66.9494476318359,-45.2555618286133],[-66.8466796875,-45.2102813720703],[-66.5352783203125,-45.2044448852539],[-66.5191802978516,-45.1788940429688],[-66.588623046875,-45.1386184692383],[-66.4597320556641,-45.1436157226562],[-66.5347290039062,-45.115837097168],[-66.5219573974609,-45.086669921875],[-66.2850036621094,-45.0316696166992],[-66.1947326660156,-44.9591674804688],[-66.0152893066406,-44.9738922119141],[-65.9491729736328,-45.0222244262695],[-65.8752899169922,-45.0194473266602],[-65.8513946533203,-44.98583984375],[-65.6855621337891,-45.0430603027344],[-65.604736328125,-45.0163955688477],[-65.5847320556641,-44.924446105957],[-65.5305633544922,-44.8950042724609],[-65.7108459472656,-44.8336181640625],[-65.7191772460938,-44.7761154174805],[-65.5994567871094,-44.6180572509766],[-65.4405670166016,-44.5380630493164],[-65.3613891601562,-44.5441741943359],[-65.3875122070312,-44.5216674804688],[-65.3594512939453,-44.4830627441406],[-65.2766723632812,-44.4802780151367],[-65.3422241210938,-44.4386138916016],[-65.2280578613281,-44.336669921875],[-65.3125,-44.1869506835938],[-65.2969512939453,-44.1322250366211],[-65.2244567871094,-44.1075057983398],[-65.2102813720703,-43.9552841186523],[-65.2583465576172,-43.9697265625],[-65.3200073242188,-43.819450378418],[-65.3302917480469,-43.6677780151367],[-65.0372314453125,-43.394172668457],[-65.0280609130859,-43.3044509887695],[-64.80029296875,-43.1611175537109],[-64.4916687011719,-43.0844497680664],[-64.2950134277344,-42.9919509887695],[-64.3155670166016,-42.9494476318359],[-64.4102783203125,-42.9780578613281],[-64.5038909912109,-42.9380569458008],[-64.5939025878906,-42.9411163330078],[-64.8086242675781,-42.8402786254883],[-64.9927825927734,-42.7936172485352],[-65.01806640625,-42.7394485473633],[-64.9605560302734,-42.666389465332],[-64.8208465576172,-42.6286163330078],[-64.6219482421875,-42.5200042724609],[-64.3980560302734,-42.5158386230469],[-64.1961212158203,-42.6388931274414],[-64.2491760253906,-42.7761154174805],[-64.0869445800781,-42.8902816772461],[-63.6930618286133,-42.8216705322266],[-63.6258392333984,-42.7619476318359],[-63.6333389282227,-42.7127838134766],[-63.5780563354492,-42.6061172485352],[-63.5908355712891,-42.3169479370117],[-63.7469482421875,-42.0905609130859],[-63.8719482421875,-42.1025009155273],[-64.1991729736328,-42.2241668701172],[-64.3344573974609,-42.2366714477539],[-64.0630645751953,-42.2786178588867],[-64.0452880859375,-42.3725051879883],[-64.118896484375,-42.4344482421875],[-64.3041687011719,-42.415283203125],[-64.4519500732422,-42.4458389282227],[-64.6069488525391,-42.4188919067383],[-64.4625091552734,-42.2636184692383],[-64.8713989257812,-42.1919479370117],[-64.9941711425781,-42.1122283935547],[-65.0622253417969,-42.0100021362305],[-65.0744476318359,-41.9316711425781],[-64.9908447265625,-41.7786178588867],[-65.0291748046875,-41.6755599975586],[-64.9911193847656,-41.5108337402344],[-65.0711212158203,-41.4333343505859],[-65.1797332763672,-40.9966735839844],[-65.1258392333984,-40.8405609130859],[-65.0125122070312,-40.7719497680664],[-64.9061126708984,-40.7686157226562],[-64.9380645751953,-40.7563934326172],[-64.9263916015625,-40.7286148071289],[-64.9813995361328,-40.7219467163086],[-64.7752838134766,-40.732780456543],[-64.7975006103516,-40.7722244262695],[-64.751953125,-40.7769470214844],[-64.7491760253906,-40.8027801513672],[-64.8961181640625,-40.7986145019531],[-64.9116668701172,-40.8202819824219],[-64.8852844238281,-40.8380584716797],[-64.6911163330078,-40.8388900756836],[-64.4125061035156,-40.9094467163086],[-64.1422271728516,-41.0219497680664],[-64.0533447265625,-40.9991683959961],[-64.0583343505859,-41.0450057983398],[-63.9600067138672,-41.0644454956055],[-63.807502746582,-41.1591720581055],[-63.1419448852539,-41.1605606079102],[-63.0333404541016,-41.1483383178711],[-62.8013916015625,-41.0433349609375],[-62.7233352661133,-41.0461120605469],[-62.3211135864258,-40.8672256469727],[-62.2297286987305,-40.6636123657227],[-62.1838912963867,-40.6297225952148],[-62.3266677856445,-40.678337097168],[-62.3480606079102,-40.6072235107422],[-62.2613906860352,-40.6333389282227],[-62.2600021362305,-40.5600051879883],[-62.2911148071289,-40.5658340454102],[-62.3313903808594,-40.4983367919922],[-62.4208374023438,-40.4594497680664],[-62.4894485473633,-40.299446105957],[-62.352783203125,-40.1816711425781],[-62.3641738891602,-40.0552825927734],[-62.3200073242188,-39.8683395385742],[-62.2861175537109,-39.8547286987305],[-62.307502746582,-39.8186111450195],[-62.1891708374023,-39.8600006103516],[-62.1163940429688,-39.8394470214844],[-62.0500259399414,-39.4887657165527],[-61.858814239502,-39.2417831420898],[-61.5625457763672,-39.0122413635254],[-61.3836135864258,-38.9797286987305],[-61.162223815918,-38.998893737793],[-60.8600006103516,-38.9763946533203],[-59.7897262573242,-38.8369445800781],[-59.6100006103516,-38.7797241210938],[-59.0380630493164,-38.6925048828125],[-58.7227783203125,-38.5805587768555],[-58.3122253417969,-38.4897232055664],[-57.8458404541016,-38.2991714477539],[-57.6347274780273,-38.1800003051758],[-57.5330581665039,-38.0861129760742],[-57.5411148071289,-37.9819488525391],[-57.4805603027344,-37.8258361816406],[-57.1274160536744,-37.5],[-52.5045259401787,-37.5],[-52.5041223563969,-52.5],[-67.5,-52.5],[-67.5,-37.5],[-57.553337097168,-37.5],[-61.1163940429688,-37.5],],
			},
		},
		# Grid -4:-2 ; 1 records
		"-2" => {
			"307" => {
				"z" => "Etc/GMT-3",
				"c" => "ESRI",
				"s" => "19,1",
				"p" => [[-54.8008346557617,-22.5],[-52.5,-22.5],[-52.5,-37.5],[-52.5045259401787,-37.5],[-52.5046501159668,-32.8847579956055],[-52.7413940429688,-33.256950378418],[-53.3742980957031,-33.7406692504883],[-53.4825057983398,-33.8544464111328],[-53.537223815918,-34.0661163330078],[-53.7502822875977,-34.2575073242188],[-53.7713928222656,-34.3908386230469],[-53.9888916015625,-34.5038909912109],[-54.1300048828125,-34.623893737793],[-54.1450042724609,-34.6713943481445],[-54.256950378418,-34.6894454956055],[-54.2425003051758,-34.5813903808594],[-54.3255615234375,-34.5627822875977],[-54.2816696166992,-34.5930557250977],[-54.3458404541016,-34.6436157226562],[-54.3008346557617,-34.6500015258789],[-54.279167175293,-34.6938934326172],[-54.5311126708984,-34.8060836791992],[-54.9512939453125,-34.9777984619141],[-54.9561157226562,-34.9402847290039],[-55.0555572509766,-34.8913955688477],[-55.2566680908203,-34.9072265625],[-55.3650054931641,-34.8105621337891],[-55.6855621337891,-34.7744445800781],[-56.1686172485352,-34.9319458007812],[-56.2208404541016,-34.8894500732422],[-56.3202819824219,-34.9105606079102],[-56.4255599975586,-34.8430557250977],[-56.3672256469727,-34.7944488525391],[-56.5638961791992,-34.7725067138672],[-56.8877792358398,-34.6661148071289],[-57.1177825927734,-34.4622268676758],[-57.4577789306641,-34.4422225952148],[-57.5194473266602,-34.4644470214844],[-57.5819473266602,-34.4391708374023],[-57.8402786254883,-34.4947280883789],[-57.9072265625,-34.370002746582],[-58.0833358764648,-34.1869506835938],[-58.1854133605957,-34.1654891967773],[-58.4088554382324,-34.2292633056641],[-58.4719467163086,-34.2811126708984],[-58.5666732788086,-34.2905578613281],[-58.4841690063477,-34.341667175293],[-58.5252838134766,-34.4397277832031],[-58.4697265625,-34.5397262573242],[-58.3694458007812,-34.5838928222656],[-58.3463363647461,-34.633617401123],[-58.3447265625,-34.636116027832],[-58.1972274780273,-34.7386169433594],[-57.8136138916016,-34.865837097168],[-57.498893737793,-35.0455627441406],[-57.3355560302734,-35.1555557250977],[-57.1883392333984,-35.320556640625],[-57.1247253417969,-35.4169464111328],[-57.1297225952148,-35.4702835083008],[-57.3761138916016,-35.7813949584961],[-57.3766708374023,-35.9627838134766],[-57.2366714477539,-36.1841735839844],[-57.053337097168,-36.3141708374023],[-56.9338912963867,-36.3472290039062],[-56.9419479370117,-36.3833389282227],[-56.8477783203125,-36.3422241210938],[-56.7677841186523,-36.3475036621094],[-56.7736129760742,-36.3044509887695],[-56.7416687011719,-36.3183364868164],[-56.6716690063477,-36.5758361816406],[-56.6630630493164,-36.9005584716797],[-57.099723815918,-37.4744491577148],[-57.1274160536744,-37.5],[-67.5,-37.5],[-67.5,-24.0887924003525],[-67.3358459472656,-24.0216674804688],[-67.1508483886719,-23.3919448852539],[-67.0008392333984,-23.0027809143066],[-67.1836242675781,-22.8216667175293],[-67.1230621337891,-22.7180557250977],[-67.0122222900391,-22.6427803039551],[-67.0225067138672,-22.5238914489746],[-66.9633483886719,-22.5225028991699],[-66.9446368542836,-22.5],[-64.4659304911314,-22.5],[-64.431396484375,-22.547779083252],[-64.4525146484375,-22.6483345031738],[-64.3600006103516,-22.740837097168],[-64.3247222900391,-22.8736114501953],[-64.2533416748047,-22.5677795410156],[-64.1988330553539,-22.5],[-62.2730155814165,-22.5],[-62.2469482421875,-22.5288925170898],[-62.2591705322266,-22.6044464111328],[-62.1900024414062,-22.6300010681152],[-62.1886138916016,-22.7102813720703],[-62.0294494628906,-22.8919448852539],[-61.9863891601562,-23.0102806091309],[-61.7816696166992,-23.1475028991699],[-61.7397232055664,-23.2436141967773],[-61.5172271728516,-23.3450012207031],[-61.4969482421875,-23.4136123657227],[-61.2947235107422,-23.4891700744629],[-61.1155624389648,-23.6036148071289],[-61.1163940429688,-23.6666679382324],[-61.0247268676758,-23.7861137390137],[-60.8550033569336,-23.872501373291],[-60.6138916015625,-23.8944473266602],[-60.5733337402344,-23.951114654541],[-60.2863922119141,-24.0375022888184],[-60.0380630493164,-24.0097236633301],[-59.4727783203125,-24.3530578613281],[-59.3388900756836,-24.4888916015625],[-59.0677795410156,-24.6069450378418],[-58.803337097168,-24.7841682434082],[-58.4505615234375,-24.8569450378418],[-58.3383407592773,-24.9977798461914],[-58.2213897705078,-24.9391670227051],[-57.9808349609375,-25.0780563354492],[-57.8711166381836,-25.0877799987793],[-57.7561111450195,-25.176944732666],[-57.6402816772461,-25.3791694641113],[-57.553337097168,-25.4483337402344],[-57.577507019043,-25.5788917541504],[-57.7516708374023,-25.6705589294434],[-57.7716674804688,-25.7075004577637],[-57.7419509887695,-25.7280578613281],[-57.8109817504883,-25.7731399536133],[-57.8036117553711,-25.8347244262695],[-57.8744506835938,-25.8786125183105],[-57.849723815918,-25.9183349609375],[-57.9036178588867,-25.9583358764648],[-57.8558349609375,-26.0019454956055],[-58.0780563354492,-26.1247253417969],[-58.1100006103516,-26.1980590820312],[-58.1525039672852,-26.1886138916016],[-58.103889465332,-26.2355575561523],[-58.1725006103516,-26.2730560302734],[-58.1625061035156,-26.3197250366211],[-58.2113952636719,-26.4263916015625],[-58.1830596923828,-26.4613914489746],[-58.2191696166992,-26.5350036621094],[-58.1688919067383,-26.6027793884277],[-58.1816711425781,-26.6561126708984],[-58.2397232055664,-26.6497230529785],[-58.2463912963867,-26.7650032043457],[-58.2858352661133,-26.7719459533691],[-58.2838897705078,-26.8113899230957],[-58.3458404541016,-26.8172225952148],[-58.3216705322266,-26.8822250366211],[-58.4783401489258,-26.9391670227051],[-58.5102844238281,-27.0586128234863],[-58.5463943481445,-27.0461120605469],[-58.5641708374023,-27.1175003051758],[-58.6527786254883,-27.1583366394043],[-58.6557312011719,-27.1916122436523],[-58.5988922119141,-27.245002746582],[-58.604621887207,-27.3169212341309],[-58.2200012207031,-27.2655563354492],[-57.791389465332,-27.2922248840332],[-57.6263961791992,-27.3691673278809],[-57.1294479370117,-27.4897232055664],[-57.0716705322266,-27.4919471740723],[-56.9086151123047,-27.4177780151367],[-56.736946105957,-27.5069465637207],[-56.6730575561523,-27.4613914489746],[-56.5500030517578,-27.4525032043457],[-56.378059387207,-27.5883369445801],[-56.2708358764648,-27.4613914489746],[-56.2680587768555,-27.3875007629395],[-56.1377792358398,-27.3088912963867],[-55.8983383178711,-27.3291702270508],[-55.8425064086914,-27.4077796936035],[-55.7361145019531,-27.4394454956055],[-55.6755599975586,-27.3686141967773],[-55.5963897705078,-27.3380584716797],[-55.5675048828125,-27.2494468688965],[-55.6019515991211,-27.1683349609375],[-55.5566711425781,-27.1616668701172],[-55.5397262573242,-27.1050033569336],[-55.4550018310547,-27.0952796936035],[-55.4138946533203,-26.982780456543],[-55.2711181640625,-26.9375],[-55.1288909912109,-26.9491691589355],[-55.1288909912109,-26.8680572509766],[-55.0511169433594,-26.8002815246582],[-54.9572296142578,-26.7783355712891],[-54.9238891601562,-26.6805572509766],[-54.8061141967773,-26.6641693115234],[-54.7786178588867,-26.6108360290527],[-54.7936172485352,-26.5230560302734],[-54.6927795410156,-26.428337097168],[-54.6675033569336,-26.2388801574707],[-54.6333389282227,-26.2002792358398],[-54.6616668701172,-26.1583366394043],[-54.6408386230469,-26.0713920593262],[-54.6650009155273,-25.9825019836426],[-54.6013946533203,-25.9527778625488],[-54.6172256469727,-25.8955574035645],[-54.5858383178711,-25.8194465637207],[-54.6455612182617,-25.6625022888184],[-54.5850067138672,-25.6413917541504],[-54.5989151000977,-25.5732231140137],[-54.6169509887695,-25.4380569458008],[-54.4230575561523,-25.1430587768555],[-54.4563903808594,-25.0872230529785],[-54.452507019043,-25.0111122131348],[-54.3305587768555,-24.6794490814209],[-54.3313903808594,-24.4927787780762],[-54.248893737793,-24.3536148071289],[-54.3377838134766,-24.1438903808594],[-54.243896484375,-24.0536079406738],[-54.0802841186523,-23.9480590820312],[-53.9688949584961,-23.4469451904297],[-53.7213897705078,-23.3002815246582],[-53.5721740722656,-22.8852653503418],[-53.1568450927734,-22.7058219909668],[-52.9897154590269,-22.5],[-53.4058380126953,-22.5],[-54.8008346557617,-22.5],],
			},
		},
		# Grid -4:-1 ; 2 records
		"-1" => {
			"def_z" => "Etc/GMT-3",
			"461" => {
				"z" => "Etc/GMT-5",
				"c" => "ESRI",
				"s" => "32,1",
				"p" => [[-67.5,-22.5],[-67.5,-7.5],[-67.5,-9.55525621262759],[-66.83056640625,-9.83805656433105],[-66.6402587890625,-9.91827201843262],[-66.8880615234375,-10.086389541626],[-67.0808410644531,-10.2719459533691],[-67.1744537353516,-10.3250007629395],[-67.3241729736328,-10.3208351135254],[-67.3333435058594,-10.3700008392334],[-67.4183349609375,-10.383056640625],[-67.463623046875,-10.4555568695068],[-67.5,-10.4743934616801],[-67.5,-18.3197250366211],[-67.5,-22.5],],
			},
		},
		# Grid -4:0 ; 2 records
		"0" => {
			"def_z" => "Etc/GMT-3",
			"462" => {
				"z" => "Etc/GMT-5",
				"c" => "ESRI",
				"s" => "32,1",
				"p" => [[-67.5,-4.33916759490967],[-67.5,-7.5],[-67.5,7.5],[-67.5,6.22171607891463],[-67.4544525146484,6.19305515289307],[-67.4919891357422,6.11865329742432],[-67.4127960205078,5.99246025085449],[-67.5,5.90711590813809],[-67.5,3.72826549289063],[-67.4919586181641,3.72638845443726],[-67.3877868652344,3.49305534362793],[-67.3072357177734,3.45555543899536],[-67.2905578613281,3.39749956130981],[-67.3841705322266,3.25916624069214],[-67.4355621337891,3.25388860702515],[-67.5,3.19292096276413],[-67.5,2.67340287629626],[-67.320556640625,2.46833324432373],[-67.1925048828125,2.39249992370605],[-67.1730651855469,2.34166622161865],[-67.2108459472656,2.24055528640747],[-67.1644592285156,2.13555526733398],[-67.1094512939453,2.09444427490234],[-67.1336212158203,1.98777770996094],[-66.9916687011719,1.69583320617676],[-66.8704528808594,1.22093200683594],[-67.0766754150391,1.17333316802979],[-67.072509765625,1.62527775764465],[-67.3350067138672,2.11111068725586],[-67.4241790771484,2.14388847351074],[-67.5,2.09429894480531],[-67.5,0.67888879776001],[-67.5,-4.33916759490967],],
			},
		},
		# Grid -4:1 ; 1 records
		"1" => {
			"310" => {
				"z" => "Etc/GMT-3",
				"c" => "ESRI",
				"s" => "19,1",
				"p" => [[-54.8008346557617,7.5],[-52.5082854190407,7.5],[-52.5083465576172,15.2397089004517],[-52.5084015698499,22.5],[-52.5,22.5],[-52.5,7.5],[-53.4058380126953,7.5],[-54.8008346557617,7.5],],
			},
		},
		# Grid -4:2 ; 2 records
		"2" => {
			"def_z" => "Atlantic/Bermuda",
			"311" => {
				"z" => "Etc/GMT-3",
				"c" => "ESRI",
				"s" => "19,1",
				"p" => [[-54.8008346557617,22.5],[-52.5084015698499,22.5],[-52.5084571838379,29.8397083282471],[-52.5079111250777,37.5],[-52.5,37.5],[-52.5,22.5],[-53.4058380126953,22.5],[-54.8008346557617,22.5],],
			},
		},
		# Grid -4:3 ; 7 records
		"3" => {
			"def_z1" => "-57.0,50.0,America/St_Johns",
			"def_z0" => "-64.7666667,46.0833333,America/Moncton",
			"def_z2" => "-56.3813889,47.0975,America/Miquelon",
			"def_z3" => "-63.6,44.65,America/Halifax",
			"13" => {
				"z" => "America/St_Johns",
				"c" => "ESRI",
				"s" => "4,1",
				"p" => [[-55.6205537255841,52.5],[-55.6051025390625,52.4621200561523],[-55.6156349182129,52.1251411437988],[-55.3937568664551,51.6440773010254],[-55.5355072021484,50.9342384338379],[-55.440860748291,50.7922706604004],[-55.5039558410645,50.0351066589355],[-55.4329719543457,49.9483489990234],[-55.7800064086914,49.7669448852539],[-55.724796295166,49.6801834106445],[-55.3304405212402,49.538215637207],[-55.0701675415039,49.5855407714844],[-54.8177795410156,49.7038459777832],[-54.0921630859375,49.774829864502],[-53.910758972168,49.6091995239258],[-53.4375305175781,49.2700538635254],[-53.5952758789062,48.930908203125],[-53.5637245178223,48.8283767700195],[-53.5716133117676,48.7100677490234],[-53.5085144042969,48.5917625427246],[-53.4138717651367,48.6390838623047],[-53.2640151977539,48.5996513366699],[-53.0826110839844,48.7258415222168],[-52.9406433105469,48.5917625427246],[-53.0510635375977,48.4182472229004],[-53.3665466308594,48.2526168823242],[-53.1851425170898,48.1027603149414],[-52.9327545166016,48.2052917480469],[-52.7276916503906,48.1658592224121],[-52.7750129699707,48.086986541748],[-53.0195159912109,47.9055824279785],[-53.0983848571777,47.6926307678223],[-52.8854331970215,47.6926307678223],[-52.8144493103027,47.8345985412598],[-52.6803703308105,47.763614654541],[-52.5936088562012,47.5112266540527],[-52.8065643310547,47.164192199707],[-52.9012069702148,46.7698364257812],[-53.1220474243164,46.596321105957],[-53.3271102905273,46.6673049926758],[-53.4217567443848,46.6673049926758],[-53.5321769714355,46.596321105957],[-53.6189346313477,46.6199836730957],[-53.6820335388184,46.6988525390625],[-53.6425971984863,46.9196929931641],[-53.8003387451172,46.9433555603027],[-53.9186477661133,46.8408203125],[-54.0606155395508,46.7777252197266],[-54.2104682922363,46.7856101989746],[-54.2104682922363,46.9196929931641],[-54.0369529724121,47.2509536743164],[-54.3603248596191,47.3771438598633],[-54.9912948608398,47.1720809936523],[-55.1411514282227,46.9749031066895],[-55.3541030883789,46.8250465393066],[-56.1033782958984,46.8408203125],[-56.1033782958984,46.9039192199707],[-55.8983154296875,47.0774345397949],[-55.716911315918,47.1405334472656],[-55.8825378417969,47.2509536743164],[-56.0166206359863,47.2430648803711],[-56.3005561828613,47.5900993347168],[-56.8132209777832,47.479679107666],[-56.9709625244141,47.3455963134766],[-57.7123527526855,47.5822105407715],[-58.2959976196289,47.6216468811035],[-59.2109031677246,47.5270004272461],[-59.3292121887207,47.5900993347168],[-59.4396324157715,47.9055824279785],[-59.2897758483887,48.4892311096191],[-59.226676940918,48.5838737487793],[-58.7771110534668,48.8126029968262],[-58.3906440734863,49.1990699768066],[-57.9410781860352,49.8063774108887],[-57.3258819580078,50.8632545471191],[-57.1057205200195,51.0327033996582],[-57.0843240431333,52.5],[-55.6205537255841,52.5],],
			},
			"312" => {
				"z" => "Etc/GMT-3",
				"c" => "ESRI",
				"s" => "19,1",
				"p" => [[-54.8008346557617,37.5],[-52.5079111250777,37.5],[-52.5068418601262,52.5],[-52.5,52.5],[-52.5,37.5],[-53.4058380126953,37.5],[-54.8008346557617,37.5],],
			},
			"326" => {
				"z" => "America/Miquelon",
				"c" => "ESRI",
				"s" => "19,4",
				"p" => [[-56.7498588562012,47.1683044433594],[-56.1287231445312,47.1683044433594],[-56.1287231445312,46.4806175231934],[-56.7498588562012,46.4806175231934],[-56.7498588562012,47.1683044433594],],
			},
			"463" => {
				"z" => "Etc/GMT-5",
				"c" => "ESRI",
				"s" => "32,1",
				"p" => [[-66.8338928222656,52.5],[-66.4246598532306,52.5],[-66.3580474853516,52.4066543579102],[-66.4586181640625,52.3661041259766],[-66.4855499267578,52.3072128295898],[-66.4388885498047,52.2008285522461],[-66.3355560302734,52.1363830566406],[-66.3038787841797,52.2227630615234],[-66.3197326660156,52.2891616821289],[-66.2666625976562,52.3113784790039],[-66.1738891601562,52.2205429077148],[-66.0680694580078,52.2163848876953],[-66.0675048828125,52.1227645874023],[-65.9169464111328,52.0508270263672],[-65.8016662597656,52.0427703857422],[-65.7994384765625,52.0955429077148],[-65.7586212158203,52.1113815307617],[-65.58056640625,52.0427703857422],[-65.4613952636719,52.206657409668],[-65.1086120605469,52.1708297729492],[-64.8533325195312,52.0219345092773],[-64.8458404541016,51.9308242797852],[-64.5877838134766,51.8288803100586],[-64.5938873291016,51.7961044311523],[-64.7180633544922,51.7477722167969],[-64.7030639648438,51.6927642822266],[-64.6041717529297,51.6427688598633],[-64.5811157226562,51.5577697753906],[-64.4424896240234,51.6677703857422],[-64.2641754150391,51.7397155761719],[-64.3572235107422,51.8505477905273],[-64.3175048828125,51.9036026000977],[-64.3308410644531,51.9652709960938],[-64.2744445800781,52.0033264160156],[-64.2933349609375,52.04638671875],[-64.2577819824219,52.128044128418],[-64.1186065673828,52.1447143554688],[-64.1313781738281,52.281379699707],[-64.0830688476562,52.3763809204102],[-64.1732380586512,52.5],[-64.0568546597262,52.5],[-64.0808410644531,52.4760971069336],[-64.0375061035156,52.4344329833984],[-63.9622192382812,52.4519348144531],[-63.9188919067383,52.3894348144531],[-64.0130615234375,52.3872146606445],[-63.9875030517578,52.3624954223633],[-64.0252838134766,52.3544387817383],[-63.9180603027344,52.3361053466797],[-63.8291702270508,52.2599945068359],[-63.8464050292969,51.9999961853027],[-63.0500068664551,51.9999961853027],[-63.044189453125,48.5046691894531],[-63.8402481079102,48.4071159362793],[-64.5283889770508,48.3266830444336],[-64.7696762084961,48.1747589111328],[-65.3237609863281,47.9692115783691],[-66.3727035522461,48.0866050720215],[-66.8437042236328,47.9966506958008],[-66.943603515625,47.9630508422852],[-66.9469451904297,47.8991622924805],[-67.0472259521484,47.9308242797852],[-67.1885986328125,47.8838806152344],[-67.3227844238281,47.8963851928711],[-67.3566589355469,47.8416595458984],[-67.5,47.8963546644751],[-67.5,45.6025645712168],[-67.4125061035156,45.5869369506836],[-67.4108276367188,45.5299911499023],[-67.4852752685547,45.4944381713867],[-67.4163970947266,45.3988800048828],[-67.4627838134766,45.2761001586914],[-67.3419494628906,45.1499938964844],[-67.2750091552734,45.1988754272461],[-67.20654296875,45.1830368041992],[-67.1583786010742,45.1741828918457],[-67.092887878418,45.0901870727539],[-66.9733047485352,44.9122276306152],[-66.953369140625,44.8268089294434],[-67.1170959472656,44.6972541809082],[-67.5,44.481588670716],[-67.5,37.5],[-67.5,52.5],[-63.4352722167969,52.5],[-66.8338928222656,52.5],],
			},
			"486" => {
				"z" => "America/St_Johns",
				"c" => "ESRI",
				"s" => "33,3",
				"p" => [[-57.0843240431333,52.5],[-57.1057205200195,51.0327033996582],[-57.3258819580078,50.8632545471191],[-57.9410781860352,49.8063774108887],[-58.3906440734863,49.1990699768066],[-58.7771110534668,48.8126029968262],[-59.226676940918,48.5838737487793],[-59.2897758483887,48.4892311096191],[-59.4396324157715,47.9055824279785],[-59.3292121887207,47.5900993347168],[-59.2109031677246,47.5270004272461],[-58.2959976196289,47.6216468811035],[-57.7123527526855,47.5822105407715],[-56.9709625244141,47.3455963134766],[-56.8132209777832,47.479679107666],[-56.3005561828613,47.5900993347168],[-56.0166206359863,47.2430648803711],[-55.8825378417969,47.2509536743164],[-55.716911315918,47.1405334472656],[-55.8983154296875,47.0774345397949],[-56.1033782958984,46.9039192199707],[-56.1033782958984,46.8408203125],[-55.3541030883789,46.8250465393066],[-55.1411514282227,46.9749031066895],[-54.9912948608398,47.1720809936523],[-54.3603248596191,47.3771438598633],[-54.0369529724121,47.2509536743164],[-54.2104682922363,46.9196929931641],[-54.2104682922363,46.7856101989746],[-54.0606155395508,46.7777252197266],[-53.9186477661133,46.8408203125],[-53.8003387451172,46.9433555603027],[-53.6425971984863,46.9196929931641],[-53.6820335388184,46.6988525390625],[-53.6189346313477,46.6199836730957],[-53.5321769714355,46.596321105957],[-53.4217567443848,46.6673049926758],[-53.3271102905273,46.6673049926758],[-53.1220474243164,46.596321105957],[-52.9012069702148,46.7698364257812],[-52.8065643310547,47.164192199707],[-52.5936088562012,47.5112266540527],[-52.6803703308105,47.763614654541],[-52.8144493103027,47.8345985412598],[-52.8854331970215,47.6926307678223],[-53.0983848571777,47.6926307678223],[-53.0195159912109,47.9055824279785],[-52.7750129699707,48.086986541748],[-52.7276916503906,48.1658592224121],[-52.9327545166016,48.2052917480469],[-53.1851425170898,48.1027603149414],[-53.3665466308594,48.2526168823242],[-53.0510635375977,48.4182472229004],[-52.9406433105469,48.5917625427246],[-53.0826110839844,48.7258415222168],[-53.2640151977539,48.5996513366699],[-53.4138717651367,48.6390838623047],[-53.5085144042969,48.5917625427246],[-53.5716133117676,48.7100677490234],[-53.5637245178223,48.8283767700195],[-53.5952758789062,48.930908203125],[-53.4375305175781,49.2700538635254],[-53.910758972168,49.6091995239258],[-54.0921630859375,49.774829864502],[-54.8177795410156,49.7038459777832],[-55.0701675415039,49.5855407714844],[-55.3304405212402,49.538215637207],[-55.724796295166,49.6801834106445],[-55.7800064086914,49.7669448852539],[-55.4329719543457,49.9483489990234],[-55.5039558410645,50.0351066589355],[-55.440860748291,50.7922706604004],[-55.5355072021484,50.9342384338379],[-55.3937568664551,51.6440773010254],[-55.6156349182129,52.1251411437988],[-55.6051025390625,52.4621200561523],[-55.6205537255841,52.5],[-55.742000579834,52.5],[-57.0843240431333,52.5],],
			},
			"488" => {
				"z" => "America/Miquelon",
				"c" => "ESRI",
				"s" => "33,4",
				"p" => [[-56.7498588562012,46.4806175231934],[-56.1287231445312,46.4806175231934],[-56.1287231445312,47.1683044433594],[-56.7498588562012,47.1683044433594],[-56.7498588562012,46.4806175231934],],
			},
		},
		# Grid -4:4 ; 5 records
		"4" => {
			"def_z" => "America/St_Johns",
			"14" => {
				"z" => "America/St_Johns",
				"c" => "ESRI",
				"s" => "4,1",
				"p" => [[-59.4396324157715,52.5],[-57.0843240431333,52.5],[-57.0741271972656,53.1992645263672],[-55.742000579834,53.1992645263672],[-55.7683296203613,52.8622856140137],[-55.6205537255841,52.5],[-55.716911315918,52.5],[-59.4396324157715,52.5],],
			},
			"313" => {
				"z" => "Etc/GMT-3",
				"c" => "ESRI",
				"s" => "19,1",
				"p" => [[-54.8008346557617,52.5],[-52.5068418601262,52.5],[-52.5059547424316,64.9447784423828],[-53.0173110961914,65.3589782714844],[-53.7127532958984,66.0544204711914],[-54.0093421936035,67.1026992797852],[-53.883877987263,67.5],[-52.5,67.5],[-52.5,52.5],[-53.4058380126953,52.5],[-54.8008346557617,52.5],],
			},
			"464" => {
				"z" => "Etc/GMT-5",
				"c" => "ESRI",
				"s" => "32,1",
				"p" => [[-67.5,52.5],[-67.5,67.5],[-62.5651343025898,67.5],[-61.9401588439941,67.3029632568359],[-61.1259613037109,66.9002456665039],[-60.9333534240723,66.6288452148438],[-61.4323806762695,66.1911010742188],[-61.9751777648926,65.8846817016602],[-62.0889930725098,65.516975402832],[-62.6493034362793,65.4819564819336],[-63.5072746276855,64.8253479003906],[-63.9712829589844,63.7660102844238],[-63.980037689209,63.258228302002],[-64.2952117919922,62.4440307617188],[-64.6278991699219,61.3409194946289],[-64.3999328613281,60.3821601867676],[-64.4810791015625,60.3665161132812],[-64.5332489013672,60.3024978637695],[-64.5675048828125,60.3047103881836],[-64.8586120605469,60.2558288574219],[-64.7672271728516,60.1749954223633],[-64.6372222900391,60.1783294677734],[-64.5977783203125,60.1174926757812],[-64.7341613769531,60.1033248901367],[-64.7024993896484,60.0649948120117],[-64.7969512939453,60.0397186279297],[-64.9063873291016,60.0480499267578],[-64.8477783203125,59.9641571044922],[-64.6536102294922,59.9299926757812],[-64.6619110107422,59.8836059570312],[-64.7677764892578,59.8799896240234],[-64.7444458007812,59.8449935913086],[-64.8141632080078,59.8188858032227],[-64.7730560302734,59.6988754272461],[-64.8330688476562,59.5397186279297],[-64.7008361816406,59.4458236694336],[-64.4324951171875,59.5294342041016],[-64.3433380126953,59.501106262207],[-64.5069580078125,59.4283294677734],[-64.4850006103516,59.3963851928711],[-64.5380554199219,59.3736038208008],[-64.4991607666016,59.339714050293],[-64.538330078125,59.2905502319336],[-64.5075073242188,59.25],[-64.5347290039062,59.1974868774414],[-64.4930572509766,59.1588821411133],[-64.4891662597656,59.0994338989258],[-64.3497314453125,59.0666656494141],[-64.2913818359375,59.0052719116211],[-64.4608306884766,58.9844360351562],[-64.7200012207031,59.0699920654297],[-64.8294525146484,59.0324935913086],[-64.8647155761719,58.9905471801758],[-64.8388977050781,58.9586029052734],[-64.8833312988281,58.9319381713867],[-64.8094329833984,58.9111022949219],[-64.7188873291016,58.9452667236328],[-64.5680694580078,58.8872146606445],[-64.3002777099609,58.8824920654297],[-64.2586212158203,58.8499984741211],[-64.2575073242188,58.7794342041016],[-64.1561126708984,58.7452697753906],[-63.9747161865234,58.8261032104492],[-63.8333282470703,58.8324966430664],[-63.7708358764648,58.8755493164062],[-63.5883331298828,58.8463821411133],[-63.4824981689453,58.7705459594727],[-63.5061111450195,58.73193359375],[-64.0291748046875,58.6869354248047],[-64.0861206054688,58.6377716064453],[-64.1005554199219,58.5791625976562],[-64.0427703857422,58.5238800048828],[-63.8980560302734,58.5649948120117],[-63.845832824707,58.5080490112305],[-63.8155517578125,58.4780426025391],[-63.8591690063477,58.4377670288086],[-64.0025024414062,58.4252700805664],[-64.0366668701172,58.3749923706055],[-64.1630554199219,58.343879699707],[-64.2186126708984,58.2308197021484],[-64.3872222900391,58.1913757324219],[-64.4319458007812,58.0861053466797],[-64.2086181640625,58.033332824707],[-64.2144470214844,57.9774856567383],[-64.0574951171875,57.7694396972656],[-64.0225067138672,57.7713775634766],[-64.0066680908203,57.8127670288086],[-63.9266662597656,57.7972183227539],[-63.8919448852539,57.7302703857422],[-63.8255615234375,57.6902694702148],[-63.7652816772461,57.7327651977539],[-63.700553894043,57.6627655029297],[-63.6533279418945,57.7311019897461],[-63.5894393920898,57.7252655029297],[-63.6072235107422,57.6636047363281],[-63.765007019043,57.5738830566406],[-63.7572250366211,57.4344329833984],[-63.7075042724609,57.3786010742188],[-63.8369445800781,57.3258285522461],[-63.8758316040039,57.23193359375],[-63.865837097168,57.1958236694336],[-63.8394393920898,57.2005462646484],[-63.8050003051758,57.2802734375],[-63.7411117553711,57.2327651977539],[-63.7925033569336,57.1652679443359],[-63.7875061035156,57.1119384765625],[-63.8736114501953,57.0663833618164],[-63.8633346557617,56.9927673339844],[-63.9177780151367,56.9302749633789],[-63.8713836669922,56.878044128418],[-64.0052795410156,56.8505477905273],[-63.9922256469727,56.7858276367188],[-64.0836181640625,56.7655487060547],[-64.1288757324219,56.6994323730469],[-63.9449996948242,56.5497207641602],[-63.9461059570312,56.4838790893555],[-63.8713836669922,56.4394302368164],[-63.9747161865234,56.4127655029297],[-64.1697235107422,56.4277725219727],[-64.1141662597656,56.3902740478516],[-64.1058349609375,56.3313827514648],[-64.1366729736328,56.3036041259766],[-64.086669921875,56.259162902832],[-63.9747161865234,56.259162902832],[-63.8769454956055,56.2172088623047],[-64.0108337402344,56.1599884033203],[-64.0202789306641,56.0763854980469],[-63.8477783203125,56.1202697753906],[-63.879997253418,56.0769424438477],[-63.8133316040039,56.0424957275391],[-63.4449996948242,56.0227661132812],[-63.6941604614258,55.9422149658203],[-63.7152786254883,55.8591613769531],[-63.4883346557617,55.6966552734375],[-63.4480514526367,55.5994338989258],[-63.29833984375,55.523323059082],[-63.1441650390625,55.5263824462891],[-63.174446105957,55.4097137451172],[-63.0933303833008,55.3458251953125],[-63.1142272949219,55.3160781860352],[-63.5194473266602,55.1836013793945],[-63.5661087036133,55.0602722167969],[-63.4352722167969,54.9736022949219],[-63.5419464111328,54.8405456542969],[-63.6236114501953,54.6660995483398],[-63.720832824707,54.5966567993164],[-63.976188659668,54.6264572143555],[-64.3472290039062,54.7552719116211],[-64.5522155761719,54.7205429077148],[-64.8116607666016,54.7491607666016],[-65.0944519042969,54.6955413818359],[-65.4438781738281,54.7458267211914],[-65.6899871826172,54.7133255004883],[-65.8352813720703,54.8313827514648],[-65.8583374023438,54.9077682495117],[-65.9577789306641,54.9294357299805],[-66.0350036621094,54.9097137451172],[-66.239990234375,54.9919357299805],[-66.5764007568359,55.2505493164062],[-66.6819458007812,55.2533264160156],[-66.6880493164062,55.3011016845703],[-66.8002777099609,55.3399887084961],[-66.8338928222656,55.3133239746094],[-66.6888885498047,55.2041625976562],[-66.7408294677734,55.177490234375],[-66.7658386230469,55.1055526733398],[-66.6594390869141,54.9794311523438],[-66.7316741943359,54.9433212280273],[-66.6049957275391,54.7908325195312],[-66.7122192382812,54.7819366455078],[-66.7180633544922,54.73193359375],[-66.9469451904297,54.8016586303711],[-67.0280609130859,54.8977737426758],[-67.3094329833984,55.0155487060547],[-67.2738952636719,55.0666656494141],[-67.4283294677734,55.0711059570312],[-67.4530639648438,55.0188827514648],[-67.3622131347656,54.8758239746094],[-67.2633361816406,54.8252716064453],[-67.3077697753906,54.7838821411133],[-67.1849975585938,54.7194366455078],[-67.2138977050781,54.6688842773438],[-67.0363922119141,54.6216583251953],[-67.2194519042969,54.6074981689453],[-67.3055572509766,54.5041656494141],[-67.4924926757812,54.5819396972656],[-67.5,54.5808672975121],[-67.5,54.317091976803],[-67.4947204589844,54.3144378662109],[-67.5,54.3050722394671],[-67.5,54.2388906712702],[-67.4850006103516,54.2341613769531],[-67.5,54.2273718086356],[-67.5,53.8153814368555],[-67.4319458007812,53.7830505371094],[-67.491943359375,53.6038818359375],[-67.1419525146484,53.5422210693359],[-67.1288757324219,53.4641571044922],[-67.0686187744141,53.4286041259766],[-67.0677795410156,53.384162902832],[-66.9875030517578,53.4036026000977],[-66.9024963378906,53.3261032104492],[-66.9902801513672,53.2008285522461],[-66.9486083984375,53.1097183227539],[-66.9794464111328,53.0277709960938],[-67.0780639648438,52.9480438232422],[-67.0583343505859,52.8049926757812],[-67.0894470214844,52.7197113037109],[-66.8913879394531,52.6733245849609],[-66.8747100830078,52.7477722167969],[-66.8055572509766,52.6655426025391],[-66.7550048828125,52.7102737426758],[-66.6680603027344,52.7258224487305],[-66.6480560302734,52.9458236694336],[-66.5252838134766,52.9433212280273],[-66.4769439697266,53.0341644287109],[-66.3547210693359,52.9816589355469],[-66.2697296142578,52.8774871826172],[-66.3788757324219,52.8361053466797],[-66.3283386230469,52.7369384765625],[-66.4338836669922,52.7063827514648],[-66.4322204589844,52.6113815307617],[-66.3736114501953,52.5424957275391],[-66.4466552734375,52.5308227539062],[-66.4246598532306,52.5],[-64.1732380586512,52.5],[-64.2088928222656,52.5488815307617],[-64.1752777099609,52.6094360351562],[-64.2022247314453,52.6722183227539],[-64.1566619873047,52.7383270263672],[-64.2014007568359,52.7908325195312],[-64.1725006103516,52.850830078125],[-64.0808410644531,52.8813781738281],[-63.9541702270508,52.8716583251953],[-63.9827728271484,52.9336013793945],[-63.9194488525391,52.976936340332],[-63.9280548095703,53.071662902832],[-63.8663940429688,53.1052703857422],[-63.6549987792969,53.1049957275391],[-63.626106262207,53.0422210693359],[-63.5480575561523,52.984992980957],[-63.5408401489258,52.9166641235352],[-63.595832824707,52.7707748413086],[-63.4230575561523,52.7072143554688],[-63.3777770996094,52.6508255004883],[-63.8630599975586,52.6127700805664],[-64.001953125,52.5547103881836],[-64.0568546597262,52.5],[-63.044189453125,52.5],[-67.5,52.5],],
			},
			"487" => {
				"z" => "America/St_Johns",
				"c" => "ESRI",
				"s" => "33,3",
				"p" => [[-52.5936088562012,52.5],[-55.6205537255841,52.5],[-55.7683296203613,52.8622856140137],[-55.742000579834,53.1992645263672],[-57.0741271972656,53.1992645263672],[-57.0843240431333,52.5],[-59.4396324157715,52.5],[-52.5936088562012,52.5],],
			},
		},
		# Grid -4:5 ; 2 records
		"5" => {
			"def_z" => "Etc/GMT-3",
			"465" => {
				"z" => "Etc/GMT-5",
				"c" => "ESRI",
				"s" => "32,1",
				"p" => [[-63.3777770996094,67.5],[-67.5,67.5],[-67.5,82.5],[-61.4291305541992,82.5],[-59.4945602416992,82.016357421875],[-60.5195503234863,81.9375076293945],[-61.4769630432129,81.7910842895508],[-61.4994926452637,81.7347640991211],[-61.0264167785645,81.475700378418],[-61.3192710876465,81.396858215332],[-61.3530654907227,81.3405380249023],[-61.3080101013184,81.1603164672852],[-61.5558090209961,81.1152648925781],[-62.2316284179688,81.2166366577148],[-62.9750289916992,81.2504272460938],[-63.8198051452637,81.149055480957],[-63.9662322998047,81.0702056884766],[-64.7997436523438,81.0026245117188],[-64.9123840332031,80.9237823486328],[-66.4442367553711,80.6083984375],[-66.7821502685547,80.7210388183594],[-66.9285736083984,80.653450012207],[-66.9285736083984,80.4732360839844],[-67.4917602539062,80.3493347167969],[-67.5,80.3410949707031],[-67.5,80.1720946486274],[-67.1087951660156,80.0452117919922],[-66.6695098876953,80.0564804077148],[-66.0838012695312,80.0001602172852],[-65.6445159912109,80.0001602172852],[-65.2953491210938,80.067741394043],[-65.1489181518555,79.8424682617188],[-64.9799652099609,79.4707717895508],[-65.9824295043945,79.1441192626953],[-67.3115386962891,79.1666488647461],[-67.5,79.1397253706131],[-67.5,70.1648979924563],[-67.2040023803711,69.9753799438477],[-66.7071685791016,69.4303894042969],[-66.5977325439453,69.2158966064453],[-66.5320739746094,68.4410934448242],[-66.0680694580078,68.3798141479492],[-64.3783798217773,68.0339965820312],[-63.7173919677734,67.8632736206055],[-62.5651343025898,67.5],[-66.4855499267578,67.5],[-63.3777770996094,67.5],],
			},
		},
		# Grid -4:6 ; 2 records
		"6" => {
			"def_z" => "Etc/GMT-5",
			"315" => {
				"z" => "Etc/GMT-3",
				"c" => "ESRI",
				"s" => "19,1",
				"p" => [[-54.8008346557617,82.5],[-52.5290899680953,82.5],[-52.5136566162109,90],[-52.5,90],[-52.5,82.5],[-53.4058380126953,82.5],[-54.8008346557617,82.5],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
