#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::ProductUseCaseCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ProductUseCaseCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::ProductUseCaseCodeType

=head1 DESCRIPTION

Specifies the context in which the product selling page is being called,
which will imply certain validation rules. Use this code list to make sure
you retrieve the appropriate version of product information and characteristic
meta-data when you are listing an item with Pre-filled Item Information.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 AddItem

(in) Use this code when calling GetProductSellingPages
before adding an item. This retrieves the latest product ID and the corresponding characteristic meta-data.



=cut


use constant AddItem => scalar('AddItem');


=head2 ReviseItem

(in) Use this code when calling GetProductSellingPages
before revising an item that already contains product information.
If the product ID or data has changed, the original
product ID that you passed in and the data associated with that original version of the
product is returned. This is useful because the original Pre-filled Item Information
is used when you call ReviseItem.



=cut


use constant ReviseItem => scalar('ReviseItem');


=head2 RelistItem

(in) Use this code when calling GetProductSellingPages
before relisting an item that already contains product information.
This retrieves the latest product ID and the
corresponding characteristic meta-data (same data as AddItem).



=cut


use constant RelistItem => scalar('RelistItem');


=head2 CustomCode

(out) Reserved for internal or future use



=cut


use constant CustomCode => scalar('CustomCode');







1;   
