use 5.014;

use strict;
use warnings;
use routines;

use Test::Auto;
use Test::More;

=name

Pluto::Engine

=cut

=abstract

Functional Scripting for Perl 5

=cut

=includes

method: execute
method: resolve

=cut

=synopsis

  package Example;

  use Pluto::Engine;

  my $engine = Pluto::Engine->new(
    package => 'example',
    config => { tempdir => { package => 'File/Temp' } },
  );

=cut

=libraries

Types::Standard

=cut

=attributes

package: ro, req, Str
config: ro, opt, HashRef
library: ro, opt, Object
services: ro, opt, Object
space: ro, opt, Object

=cut

=description

This package provides an engine for resolving dependencies and dispatching
function calls, enabling a functional programming environment for Perl 5. See
L<Rewire> for more information on dependency injection.

=cut

=method execute

The execute method dispatches a routine call.

=signature execute

execute(ClassName | Object $next, Str $name, Any @args) : Any

=example-1 execute

  # given: synopsis

  $engine->execute('File::Temp', 'new', 'File::Temp');

=cut

=method resolve

The resolve method performs service lookup and resolution, and dependency
injection.

=signature resolve

resolve(Tuple[Str, Str] $pack, Any @args) : Any

=example-1 resolve

  # given: synopsis

  $engine->resolve([main => 'tempdir'], cleanup => 1);

=cut

package main;

my $test = testauto(__FILE__);

my $subs = $test->standard;

$subs->synopsis(fun($tryable) {
  ok my $result = $tryable->result;
  ok $result->isa('Pluto::Engine');
  is $result->package, 'example';

  $result
});

$subs->example(-1, 'execute', 'method', fun($tryable) {
  ok my $result = $tryable->result;

  $result
});

$subs->example(-1, 'resolve', 'method', fun($tryable) {
  ok my $result = $tryable->result;

  $result
});

ok 1 and done_testing;
