package Bencher::Scenario::ShellGuess::running_shell;

our $DATE = '2021-07-31'; # DATE
our $VERSION = '0.003'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark running_shell()',
    participants => [
        {
            module => 'Shell::Guess',
            function => 'running_shell',
            code_template=>'my $s = Shell::Guess->running_shell; $s->name',
        },
    ],
};

1;
# ABSTRACT: Benchmark running_shell()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ShellGuess::running_shell - Benchmark running_shell()

=head1 VERSION

This document describes version 0.003 of Bencher::Scenario::ShellGuess::running_shell (from Perl distribution Bencher-Scenarios-ShellGuess), released on 2021-07-31.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ShellGuess::running_shell

To run module startup overhead benchmark:

 % bencher --module-startup -m ShellGuess::running_shell

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Shell::Guess> 0.06

=head1 BENCHMARK PARTICIPANTS

=over

=item * Shell::Guess::running_shell (perl_code)

Code template:

 my $s = Shell::Guess->running_shell; $s->name



=back

=head1 BENCHMARK SAMPLE RESULTS

=head2 Sample benchmark #1

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark command (under bash):

 % 

Result formatted as table:

 #table1#
 +-----------------------------+------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant                 | perl | rate (/s) | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +-----------------------------+------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | Shell::Guess::running_shell | perl |     50000 |        20 |                     0 |                     0 | 2.7e-08 |      20 |
 +-----------------------------+------+-----------+-----------+-----------------------+-----------------------+---------+---------+


The above result formatted in L<Benchmark.pm|Benchmark> style:

        Rate     
     50000/s  -- 
 
 Legends:
   : participant=Shell::Guess::running_shell perl=perl

The above result presented as chart:

=begin html

<img src="data:image/png;base64,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" />

=end html


=head2 Sample benchmark #2

Benchmark command (under fish):

 % 

Result formatted as table:

 #table2#
 +-----------------------------+------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant                 | perl | rate (/s) | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +-----------------------------+------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | Shell::Guess::running_shell | perl |     50000 |        20 |                     0 |                     0 | 2.6e-08 |      21 |
 +-----------------------------+------+-----------+-----------+-----------------------+-----------------------+---------+---------+


The above result formatted in L<Benchmark.pm|Benchmark> style:

        Rate     
     50000/s  -- 
 
 Legends:
   : participant=Shell::Guess::running_shell perl=perl

The above result presented as chart:

=begin html

<img src="data:image/png;base64,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" />

=end html


=head2 Sample benchmark #3

Benchmark command (under tcsh ('c')):

 % 

Result formatted as table:

 #table3#
 +-----------------------------+------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant                 | perl | rate (/s) | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +-----------------------------+------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | Shell::Guess::running_shell | perl |     45000 |        22 |                     0 |                     0 | 2.7e-08 |      20 |
 +-----------------------------+------+-----------+-----------+-----------------------+-----------------------+---------+---------+


The above result formatted in L<Benchmark.pm|Benchmark> style:

        Rate     
     45000/s  -- 
 
 Legends:
   : participant=Shell::Guess::running_shell perl=perl

The above result presented as chart:

=begin html

<img src="data:image/png;base64,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" />

=end html


=head2 Sample benchmark #4

Benchmark command (under zsh ('z')):

 % 

Result formatted as table:

 #table4#
 +-----------------------------+------+-----------+-----------+-----------------------+-----------------------+--------+---------+
 | participant                 | perl | rate (/s) | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest | errors | samples |
 +-----------------------------+------+-----------+-----------+-----------------------+-----------------------+--------+---------+
 | Shell::Guess::running_shell | perl |     49100 |      20.4 |                     0 |                     0 |  2e-08 |      20 |
 +-----------------------------+------+-----------+-----------+-----------------------+-----------------------+--------+---------+


The above result formatted in L<Benchmark.pm|Benchmark> style:

        Rate     
     49100/s  -- 
 
 Legends:
   : participant=Shell::Guess::running_shell perl=perl

The above result presented as chart:

=begin html

<img src="data:image/png;base64,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" />

=end html


To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-ShellGuess>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-ShellGuess>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-ShellGuess>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021, 2017, 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
