use TestHelpers qw/ db read_data read_file /;
use Mojo::JSON qw/ j /;

my $db =  db();
$db->txn_begin;

use aliased 'DBIx::Class::Migration' => 'DBICM';
my $dbicm =  DBICM->new(
	schema       =>  $db,
	dbic_dh_args =>  { to_version => 13 },
);

$dbicm->install;

# Run arbitrary SQL from the folder relative to test and start a transaction
D::do read_file 'sql/script.sql';
$db->svp_begin( 'start' );     # Save a point at the transaction (nest the transaction)

my( $got, $data );

# Ignore whole test file
my $reason =  todo 'These are examples for developers';


# Wrap subtest to mark it as TODO
{my $reason =  todo 'Ignore only one subtest';
$got  =  '';
$data =  eval read_data '';
is $got, $data, "Test name";
}


$got  =  D::q <<SQL;
SELECT 1;
SQL
my $e =  $@; # You can dump $e to check errors during a structure reading
like $got, qr/ERROR:  /, "Test name";
$db->svp_rollback( 'start' );  # Rollback the query with errors to some point


$got  =  D::q <<SQL;
SQL
$data =  eval read_data 'expected-structure';
is $got, $data, "Test name";

$db->svp_release( 'start' );   # Release the saved point (unnest the transaction)

$db->txn_rollback;
done_testing;

__DATA__
@@ expected-structure
{
  key  =>  'value',
  what =>  'Any perl code here',
}
