package # I - Iterator
	I;  # Hide from PAUSE

use strict;
use warnings;



sub new { bless { data => shift }, 'I' }


sub pos { shift->{ pos } }


sub item {
	my $i =  shift;

	$i->{ data }[ shift  // $i->{ pos } ];
}


sub first {
	my $i =  shift;

	$i->{ pos } =  0;
	$i->item;
}


sub next {
	my $i =  shift;

	$i->{ pos }++;
	$i->item;
}



1;

=encoding utf8

=head1 NAME

I - Iterator


=head1 SYNOPSIS

  use I;

  my $it =  I->new( [qw/a b c/] );

  my $first =  $it->first;  # a
  my $next  =  $it->next;   # b
  my $pos   =  $it->pos;    # 1
  my $item  =  $it->item;   # b


=head1 DESCRIPTION

I is a tiny iterator over an array reference. It tracks the current position
and returns items from the underlying array. Could be used when you are trying
to mock iteration over ResultSet. See L<DBIx::Class>.


=head1 METHODS


=head2 new

  my $it =  I->new( $arrayref );

Create a new iterator for the given array reference.


=head2 pos

  my $pos =  $it->pos;

Return the current position, or C<undef> if iteration has not started.


=head2 item

  my $value =  $it->item;
  my $value =  $it->item( $pos );

Return the item at the given C<$index> or at the current position.


=head2 first

  my $value =  $it->first;

Set position to C<0> and return the first item.


=head2 next

  my $value =  $it->next;

Increment the position and return the next item.


=head1 SEE ALSO

L<A>, L<C>, L<I>, L<L>, L<M>, L<S>, L<T>, L<U>.

=cut
