use utf8;
use strict;

use Test::More 'no_plan';
use File::stat;
use lib 't/lib';

use TreePath::Graph::Test;

my $simpletree = {
             'T1_1' => {
                    id => '1',
                    source => 'T1',
                    parent => '',
                    name => '/',},
             'T1_2'=> {
                    id => '2',
                    source => 'T1',
                    parent =>  { 'T1_1' },
                    name => 'A'},
             'T1_3'=> {
                    id => '3',
                    source => 'T1',
                    parent =>  { 'T1_2' },
                    name => 'B'},
             'T1_4'=> {
                    id => '4',
                    source => 'T1',
                    parent =>  { 'T1_3' },
                    name => 'C'},
             'T1_5'=> {
                    id => '5',
                    source => 'T1',
                    parent =>  { 'T1_4' },
                    name => 'D'},
             'T1_6'=> {
                    id => '6',
                    source => 'T1',
                    parent =>  { 'T1_4' },
                    name => 'E'},
             'T1_7'=> {
                    id => '7',
                    source => 'T1',
                    parent =>  { 'T1_2' },
                    name => '♥'},
             'T1_8'=> {
                    id => '8',
                    source => 'T1',
                    parent =>  { 'T1_7' },
                    name => 'G'},
             'T1_9'=> {
                    id => '9',
                    source => 'T1',
                    parent => { 'T1_7' },
                    name => 'E'},
             'T1_10'=> {
                    id => '10',
                    source => 'T1',
                     parent =>  { 'T1_9' },
                     name => 'I'},
             'T1_11'=> {
                     id => '11',
                     source => 'T1',
                     parent => { 'T1_9' },
                     name => 'J'},
             'T2_1' => {
                    id => '1',
                    source => 'T2',
                    parent => { 'T1_1' }},
             'T2_2' => {
                    id => '2',
                    source => 'T2',
                    parent => { 'T1_1' }},
             'T2_3' => {
                    id => '3',
                    source => 'T2',
                    parent => { 'T1_2' }},
             'T2_4' => {
                    id => '4',
                    source => 'T2',
                    parent => { 'T1_2' }},
             'T2_5' => {
                    id => '5',
                    source => 'T2',
                    parent => { 'T1_1' }},
             'T2_6' => {
                    id => '6',
                    source => 'T2',
                    parent => { 'T1_7' }},
             'T3_1' => {
                    id => '1',
                    source => 'T3',
                    parent => { 'T2_6' }},
             'T3_2' => {
                    id => '2',
                    source => 'T3',
                    parent => { 'T2_6' }},
            };


my $colors_source = {
                   'T1' => { fg => 'blue'},
                   'T2' => { fg => 'magenta'},
                   'T3' => { fg => 'brown'},
            };



ok( my $tp = TreePath::Graph::Test->new(  conf   => $simpletree,
                                          colors => $colors_source,
                                          output => 't/test.png',
                                          ),
    "New TreePath ( conf => $simpletree) with TreePath::Role::Graph");

$tp->graph;

my $sb = stat($tp->output);
ok( $sb->size > 0, "png size is not nulle");

unlink $tp->output;
