#!perl

use strict;
use warnings;
use Test::More tests => 12;
use Pod::Advent;
use Test::Differences;
use IO::CaptureOutput qw(capture);

my @files = (
  [ 'ex/sample.pod', 'ex/sample.html', '', [qw/ href lt pre mispelling mispelling /] ],
  [ 'ex/getting_started.pod', 'ex/getting_started.html', '', ],
  [ 'ex/footnotes.pod', 'ex/footnotes.html', '', [qw/ sourcedcode /] ],
);
foreach my $info ( @files ){
  my ($podfile, $htmlfile, $errors, $words) = @$info;
  $words ||= [];
  my ($stdout, $stderr);
  my $advent = Pod::Advent->new;
  capture( sub {
	eval {
	$advent->parse_file( $podfile );
	} or warn $@;
    }, \$stdout, \$stderr );

  my $html = do{ local $/ = undef; open FILE, '<', $htmlfile; <FILE> };
  s/^<!-- Generated by Pod::Advent .+? -->$//m for $html, $stdout;

  eq_or_diff($stdout, $html,   "[$podfile] file matches");
  eq_or_diff($stderr, $errors, "[$podfile] errors match");

  SKIP: {
    skip 'spellcheck disabled', 2 unless $advent->spellcheck_enabled;
    is( $advent->num_spelling_errors, scalar(@$words), "[$podfile] misspelled word ct" );
    eq_or_diff( [ $advent->spelling_errors ], $words, "[$podfile] misspelled words" );
  }
}

