/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.util;

import java.util.ArrayList;
import java.util.List;

public class Getopt {
    private int optind = -1;
    private List<CommandLineOption> options = new ArrayList<CommandLineOption>();

    public Getopt addOption(CommandLineOption option) {
        this.options.add(option);
        return this;
    }

    public List<Entry> parse(String[] argv) {
        int idx;
        this.optind = -1;
        ArrayList<Entry> ret = new ArrayList<Entry>();
        for (idx = 0; idx < argv.length; ++idx) {
            if (argv[idx].equals("--")) {
                ++idx;
                break;
            }
            if (argv[idx].charAt(0) != '-') break;
            if (argv[idx].startsWith("--")) {
                String key = argv[idx];
                int ii = key.indexOf(61);
                if (ii != -1) {
                    key = key.substring(0, ii);
                }
                boolean found = false;
                for (CommandLineOption o : this.options) {
                    if (!key.equals(o.longopt)) continue;
                    found = true;
                    String value = null;
                    if (o.hasArgument) {
                        if (ii != -1) {
                            value = argv[idx].substring(ii + 1);
                        } else if (idx + 1 < argv.length) {
                            value = argv[idx + 1];
                            ++idx;
                        } else {
                            throw new IllegalArgumentException("option requires an argument -- " + key);
                        }
                    }
                    ret.add(new Entry(key, value));
                }
                if (found) continue;
                throw new IllegalArgumentException("Illegal option -- " + key);
            }
            if (!argv[idx].startsWith("-")) break;
            String keys = argv[idx].substring(1);
            for (char c : keys.toCharArray()) {
                String key = "-" + c;
                boolean found = false;
                for (CommandLineOption o : this.options) {
                    if (key.charAt(1) != o.shortopt) continue;
                    found = true;
                    String value = null;
                    if (o.hasArgument) {
                        if (idx + 1 < argv.length) {
                            value = argv[idx + 1];
                            ++idx;
                        } else {
                            throw new IllegalArgumentException("option requires an argument -- " + key);
                        }
                    }
                    ret.add(new Entry(key, value));
                }
                if (found) continue;
                throw new IllegalArgumentException("Illegal option -- " + key);
            }
        }
        if (idx != argv.length) {
            this.optind = idx;
        }
        return ret;
    }

    public int getOptind() {
        return this.optind;
    }

    public static class Entry {
        public String key;
        public String value;

        public Entry(String k, String v) {
            this.key = k;
            this.value = v;
        }
    }

    public static class CommandLineOption {
        private char shortopt;
        private String longopt;
        private boolean hasArgument;

        public CommandLineOption(char shortopt, String longopt, boolean hasArgument) {
            this.shortopt = shortopt;
            this.longopt = longopt;
            this.hasArgument = hasArgument;
        }
    }
}

