/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.common.ECI;
import java.util.Hashtable;

public final class CharacterSetECI
extends ECI {
    private static Hashtable VALUE_TO_ECI;
    private static Hashtable NAME_TO_ECI;
    private final String encodingName;

    private static void initialize() {
        VALUE_TO_ECI = new Hashtable(29);
        NAME_TO_ECI = new Hashtable(29);
        CharacterSetECI.addCharacterSet(0, "Cp437");
        CharacterSetECI.addCharacterSet(1, new String[]{"ISO8859_1", "ISO-8859-1"});
        CharacterSetECI.addCharacterSet(2, "Cp437");
        CharacterSetECI.addCharacterSet(3, new String[]{"ISO8859_1", "ISO-8859-1"});
        CharacterSetECI.addCharacterSet(4, "ISO8859_2");
        CharacterSetECI.addCharacterSet(5, "ISO8859_3");
        CharacterSetECI.addCharacterSet(6, "ISO8859_4");
        CharacterSetECI.addCharacterSet(7, "ISO8859_5");
        CharacterSetECI.addCharacterSet(8, "ISO8859_6");
        CharacterSetECI.addCharacterSet(9, "ISO8859_7");
        CharacterSetECI.addCharacterSet(10, "ISO8859_8");
        CharacterSetECI.addCharacterSet(11, "ISO8859_9");
        CharacterSetECI.addCharacterSet(12, "ISO8859_10");
        CharacterSetECI.addCharacterSet(13, "ISO8859_11");
        CharacterSetECI.addCharacterSet(15, "ISO8859_13");
        CharacterSetECI.addCharacterSet(16, "ISO8859_14");
        CharacterSetECI.addCharacterSet(17, "ISO8859_15");
        CharacterSetECI.addCharacterSet(18, "ISO8859_16");
        CharacterSetECI.addCharacterSet(20, new String[]{"SJIS", "Shift_JIS"});
    }

    private CharacterSetECI(int n, String string) {
        super(n);
        this.encodingName = string;
    }

    public String getEncodingName() {
        return this.encodingName;
    }

    private static void addCharacterSet(int n, String string) {
        CharacterSetECI characterSetECI = new CharacterSetECI(n, string);
        VALUE_TO_ECI.put(new Integer(n), characterSetECI);
        NAME_TO_ECI.put(string, characterSetECI);
    }

    private static void addCharacterSet(int n, String[] stringArray) {
        CharacterSetECI characterSetECI = new CharacterSetECI(n, stringArray[0]);
        VALUE_TO_ECI.put(new Integer(n), characterSetECI);
        for (int i = 0; i < stringArray.length; ++i) {
            NAME_TO_ECI.put(stringArray[i], characterSetECI);
        }
    }

    public static CharacterSetECI getCharacterSetECIByValue(int n) {
        if (VALUE_TO_ECI == null) {
            CharacterSetECI.initialize();
        }
        if (n < 0 || n >= 900) {
            throw new IllegalArgumentException("Bad ECI value: " + n);
        }
        return (CharacterSetECI)VALUE_TO_ECI.get(new Integer(n));
    }

    public static CharacterSetECI getCharacterSetECIByName(String string) {
        if (NAME_TO_ECI == null) {
            CharacterSetECI.initialize();
        }
        return (CharacterSetECI)NAME_TO_ECI.get(string);
    }
}

