# Contributing to the **DuckDuckGo** repository

At DuckDuckGo, we truly appreciate our community members taking the time to contribute to our open-source repositories. In an effort to ensure contributions are easy for you to make and for us to manage, we have written some guidelines that we ask our contributors to follow so that we can handle pull requests in a timely manner with as little friction as possible.

## Getting Started

Before you can do anything, you first need a [GitHub account](https://github.com/signup/free). This is required because we use GitHub to handle all incoming *Pull Requests* (code modifications) and *Issues* (bug reports) which cannot be made without a GitHub account.

## Submitting a **Bug** or **Suggestion**

- Firstly, please make sure the bug is related to the **DuckDuckGo** repository. If this bug is about the DuckDuckGo API, or the relevancy of our search results, please visit our feedback page at <https://duckduckgo.com/feedback>. If you're unsure, its best to use the feedback page (your message will be passed along to the correct people).

- Check the **DuckDuckGo** [issues](https://github.com/duckduckgo/duckduckgo/issues) to see if an issue already exists for the given bug or suggestion
  - If one doesn't exist, create a GitHub issue in the **DuckDuckGo** repository
    - Clearly describe the bug/improvemnt, including steps to reproduce when it is a bug
  - If one already exists, please add any additional comments you have regarding the matter

## Submitting Changes

- Find detailed instructions for adding an **Instant Answer** [here](http://docs.duckduckhack.com/submitting/pull-request.html)
- For other changes, see [this handy guide](http://docs.duckduckhack.com/resources/git-workflow.html) on submitting a pull request

